/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleNavigationDisabledMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleNavigationHiddenMarker;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterRule;
import org.eclipse.riena.ui.filter.impl.UIFilter;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class FilterNavigationSubModuleController
extends SubModuleController {
    private IActionRidget addFilter;
    private IComboRidget filterTypeValues;
    private FilterModel filterModel;

    public void afterBind() {
        super.afterBind();
        this.initNavigationFilterGroup();
        this.rebindFilterTypeValues(this.filterModel, this.filterTypeValues, this.addFilter);
        SubApplicationNode subAppNode = (SubApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(SubApplicationNode.class);
        SubApplicationController subApp = (SubApplicationController)subAppNode.getNavigationNodeController();
        IActionRidget ridget = subApp.getMenuActionRidget("org.eclipse.riena.example.client.histBackMenuItem");
        ridget.setEnabled(false);
    }

    private void initNavigationFilterGroup() {
        ITextRidget ridgetID = (ITextRidget)this.getRidget("nodeId");
        this.filterModel = new FilterModel();
        ridgetID.bindToModel((Object)this.filterModel, "nodeId");
        ridgetID.updateFromModel();
        ISingleChoiceRidget filterType = (ISingleChoiceRidget)this.getRidget("filterType");
        filterType.addPropertyChangeListener((PropertyChangeListener)new FilterTypeChangeListener());
        filterType.bindToModel((Object)this.filterModel, "types", (Object)this.filterModel, "selectedType");
        filterType.updateFromModel();
        this.filterTypeValues = (IComboRidget)this.getRidget("filterTypeValues");
        this.filterTypeValues.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FilterNavigationSubModuleController.this.addFilter != null) {
                    FilterNavigationSubModuleController.this.addFilter.setEnabled(evt.getNewValue() != null);
                }
            }
        });
        this.addFilter = (IActionRidget)this.getRidget("addFilter");
        this.addFilter.addListener(new IActionListener(){

            public void callback() {
                FilterNavigationSubModuleController.this.doAddFilter();
            }
        });
        IActionRidget removeFilters = (IActionRidget)this.getRidget("removeFilters");
        removeFilters.addListener(new IActionListener(){

            public void callback() {
                FilterNavigationSubModuleController.this.doRemoveFilters();
            }
        });
    }

    private void rebindFilterTypeValues(FilterModel model, IComboRidget typeValues, IActionRidget add) {
        if (model == null) {
            return;
        }
        model.setSelectedFilterTypeValue(null);
        if (typeValues != null) {
            typeValues.bindToModel((IObservableList)new WritableList(Arrays.asList(model.getSelectedType().getArgs()), Object.class), FilterModel.class, null, BeansObservables.observeValue((Object)model, (String)"selectedFilterTypeValue"));
            typeValues.updateFromModel();
        }
        if (add != null) {
            add.setEnabled(model.getSelectedFilterTypeValue() != null);
        }
    }

    private void doAddFilter() {
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        ArrayList<IUIFilterRule> rules = new ArrayList<IUIFilterRule>(1);
        rules.add(this.createFilterRule(this.filterModel, this.filterModel.getNodeId()));
        UIFilter filter = new UIFilter(rules);
        applNode.addFilter((IUIFilter)filter);
    }

    private void doRemoveFilters() {
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        applNode.removeAllFilters();
    }

    private IUIFilterRule createFilterRule(FilterModel model, String nodeId) {
        UIFilterRuleNavigationDisabledMarker attribute = null;
        Object filterValue = model.getSelectedFilterTypeValue();
        FilterType type = model.getSelectedType();
        if (type == FilterType.MARKER) {
            if (filterValue instanceof DisabledMarker) {
                attribute = new UIFilterRuleNavigationDisabledMarker(nodeId);
            } else if (filterValue instanceof HiddenMarker) {
                attribute = new UIFilterRuleNavigationHiddenMarker(nodeId);
            }
        }
        return attribute;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterModel {
        private String nodeId = "";
        private List<FilterType> types;
        private FilterType selectedType;
        private Object selectedFilterTypeValue;

        public List<FilterType> getTypes() {
            if (this.types == null) {
                this.types = new ArrayList<FilterType>();
                this.types.add(FilterType.MARKER);
            }
            return this.types;
        }

        public void setSelectedType(FilterType selectedType) {
            this.selectedType = selectedType;
        }

        public FilterType getSelectedType() {
            if (this.selectedType == null) {
                this.selectedType = this.getTypes().get(0);
            }
            return this.selectedType;
        }

        public void setSelectedFilterTypeValue(Object selectedFilterTypeValue) {
            this.selectedFilterTypeValue = selectedFilterTypeValue;
        }

        public Object getSelectedFilterTypeValue() {
            return this.selectedFilterTypeValue;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeId() {
            return this.nodeId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FilterType {
        MARKER("Marker", new DisabledMarker(), new HiddenMarker());

        private String text;
        private Object[] args;

        private FilterType(String text, Object ... args) {
            this.text = text;
            this.args = args;
        }

        public String toString() {
            return this.text;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }

    private class FilterTypeChangeListener
    implements PropertyChangeListener {
        private FilterTypeChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FilterNavigationSubModuleController.this.rebindFilterTypeValues(FilterNavigationSubModuleController.this.filterModel, FilterNavigationSubModuleController.this.filterTypeValues, FilterNavigationSubModuleController.this.addFilter);
        }
    }
}

