/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.riena.ui.core.uiprocess.IProcessInfoAware;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitor;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitorContainer;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICallbackDispatcher
extends ProgressProvider
implements IUIMonitorContainer {
    private IUISynchronizer syncher;
    private List<IUIMonitor> uiMonitors = new ArrayList<IUIMonitor>();
    private ProcessInfo pInfo;
    private boolean visualize;
    private ThreadSwitcher threadSwitcher;

    public UICallbackDispatcher(IUISynchronizer syncher) {
        this.syncher = syncher;
        this.pInfo = this.createProcessInfo();
        this.visualize = true;
    }

    private ProcessInfo createProcessInfo() {
        return new ProcessInfo();
    }

    public ProcessInfo getProcessInfo() {
        return this.pInfo;
    }

    @Override
    public void addUIMonitor(IUIMonitor uiMontitor) {
        IProcessInfoAware processInfoAware = (IProcessInfoAware)uiMontitor.getAdapter(IProcessInfoAware.class);
        if (processInfoAware != null) {
            processInfoAware.setProcessInfo(this.pInfo);
        }
        this.uiMonitors.add(uiMontitor);
    }

    protected final IUISynchronizer getSyncher() {
        return this.syncher;
    }

    public final IProgressMonitor createMonitor(Job job) {
        this.threadSwitcher = this.createThreadSwitcher();
        this.observeJob(job);
        return this.threadSwitcher;
    }

    public ThreadSwitcher createThreadSwitcher() {
        return new ThreadSwitcher(this.createWrappedMonitor());
    }

    private void observeJob(Job job) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                UICallbackDispatcher.this.threadSwitcher.done();
            }
        });
    }

    private List<IUIMonitor> getActiveMonitors() {
        if (this.visualize) {
            return new ArrayList<IUIMonitor>(this.uiMonitors);
        }
        ArrayList<IUIMonitor> monitors = new ArrayList<IUIMonitor>();
        for (IUIMonitor monitor : this.uiMonitors) {
            if (!monitor.isActive(this)) continue;
            monitors.add(monitor);
        }
        return monitors;
    }

    protected IProgressMonitor createWrappedMonitor() {
        return new NullProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                UICallbackDispatcher.this.pInfo.setMaxProgress(totalWork);
                for (IUIMonitor monitor : UICallbackDispatcher.this.getActiveMonitors()) {
                    monitor.initialUpdateUI(totalWork);
                }
            }

            public void worked(int work) {
                UICallbackDispatcher.this.pInfo.setActualProgress(work);
                for (IUIMonitor monitor : UICallbackDispatcher.this.getActiveMonitors()) {
                    monitor.updateProgress(work);
                }
            }

            public void done() {
                for (IUIMonitor monitor : UICallbackDispatcher.this.getActiveMonitors()) {
                    monitor.finalUpdateUI();
                }
            }
        };
    }

    @Override
    public boolean isVisualizing() {
        return this.visualize;
    }

    public void setVisualizing(boolean visualize) {
        this.visualize = visualize;
    }

    private final class ThreadSwitcher
    extends NullProgressMonitor {
        private IProgressMonitor delegate;
        private boolean done;

        public ThreadSwitcher(IProgressMonitor wrappedMonitor) {
            this.delegate = wrappedMonitor;
        }

        public void beginTask(final String name, final int totalWork) {
            this.synchronize(new Runnable(){

                public void run() {
                    ThreadSwitcher.this.delegate.beginTask(name, totalWork);
                }
            });
        }

        public void worked(final int work) {
            this.synchronize(new Runnable(){

                public void run() {
                    ThreadSwitcher.this.delegate.worked(work);
                }
            });
        }

        public void done() {
            if (!this.done) {
                this.synchronize(new Runnable(){

                    public void run() {
                        ThreadSwitcher.this.delegate.done();
                    }
                });
                this.done = true;
            }
        }

        public void synchronize(Runnable runnable) {
            UICallbackDispatcher.this.syncher.synchronize(runnable);
        }
    }
}

