/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.objecttransaction.impl;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.objecttransaction.IObjectId;
import org.eclipse.riena.objecttransaction.IObjectTransactionExtract;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.delta.TransactionDelta;
import org.eclipse.riena.objecttransaction.state.State;

public class ObjectTransactionExtractImpl
implements IObjectTransactionExtract {
    private ArrayList<TransactionDelta> deltas = new ArrayList();

    protected ObjectTransactionExtractImpl() {
    }

    public TransactionDelta[] getDeltas() {
        return this.deltas.toArray(new TransactionDelta[0]);
    }

    public void addCleanTransactedObject(ITransactedObject transObject) {
        Assert.isTrue((!this.contains(transObject.getObjectId()) ? 1 : 0) != 0, (String)"object must not exist in extract");
        this.deltas.add(new TransactionDelta(transObject.getObjectId(), State.CLEAN, transObject.getVersion()));
    }

    public boolean contains(IObjectId objectid) {
        int i = 0;
        while (i < this.deltas.size()) {
            if (this.deltas.get(i).getObjectId().equals(objectid)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addDelta(TransactionDelta delta) {
        this.deltas.add(delta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("----------extract--------------------\n");
        int i = 0;
        while (i < this.deltas.size()) {
            sb.append(this.deltas.get(i));
            ++i;
        }
        sb.append("----------extract--------------------\n");
        return sb.toString();
    }
}

