/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.ui.ridgets.swt.MenuManagerHelper;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuCoolBarComposite
extends Composite {
    private CoolItem coolItem;
    private ToolBar toolBar;

    public MenuCoolBarComposite(Composite parent, int style) {
        super(parent, style);
        this.create();
    }

    private void create() {
        CoolBar coolBar = new CoolBar((Composite)this, 0x800000);
        this.coolItem = MenuCoolBarComposite.initCoolBar(coolBar);
        this.toolBar = (ToolBar)this.coolItem.getControl();
        this.toolBar.addMouseMoveListener((MouseMoveListener)new ToolBarMouseListener());
    }

    public static CoolItem initCoolBar(CoolBar coolBar) {
        if (coolBar.getItemCount() == 0) {
            CoolItem coolItem = new CoolItem(coolBar, 4);
            ToolBar toolBar = new ToolBar((Composite)coolBar, 0x800000);
            coolItem.setControl((Control)toolBar);
            coolItem.setSize(new Point(0, 1));
        }
        coolBar.setBackground(MenuCoolBarComposite.getCoolbarBackground());
        coolBar.setBackgroundMode(2);
        coolBar.setLocked(true);
        return coolBar.getItem(0);
    }

    private void calcSize(CoolItem item) {
        Control control = item.getControl();
        Point pt = control.computeSize(-1, -1);
        pt = item.computeSize(pt.x, pt.y);
        item.setSize(pt);
    }

    public ToolItem createAndAddMenu(MenuManager menuManager) {
        ToolItem toolItem = new ToolItem(this.toolBar, 32);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)toolItem, menuManager.getId());
        toolItem.setText(menuManager.getMenuText());
        MenuManagerHelper helper = new MenuManagerHelper();
        helper.createMenu((Composite)this.toolBar, toolItem, menuManager);
        this.calcSize(this.coolItem);
        return toolItem;
    }

    public List<ToolItem> getTopLevelItems() {
        ToolItem[] toolItems = this.toolBar.getItems();
        return Arrays.asList(toolItems);
    }

    private static Color getCoolbarBackground() {
        return LnfManager.getLnf().getColor("Coolbar.background");
    }

    private static class ToolBarMouseListener
    implements MouseMoveListener {
        private ToolBarMouseListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (e.getSource() instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)e.getSource();
                ToolItem selectedItem = null;
                ToolItem[] items = toolBar.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getSelection()) {
                        selectedItem = items[i];
                    }
                    ++i;
                }
                ToolItem hoverItem = toolBar.getItem(new Point(e.x, e.y));
                if (hoverItem != null && !hoverItem.getSelection() && selectedItem != null) {
                    selectedItem.setSelection(false);
                    hoverItem.setSelection(true);
                }
            }
        }
    }
}

