/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.monitor.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.internal.monitor.client.Activator;
import org.eclipse.riena.internal.monitor.client.ICollectorExtension;
import org.eclipse.riena.internal.monitor.client.ISenderExtension;
import org.eclipse.riena.internal.monitor.client.IStoreExtension;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.ICollectingAggregator;
import org.eclipse.riena.monitor.client.ICollector;
import org.eclipse.riena.monitor.client.ISender;
import org.eclipse.riena.monitor.client.IStore;
import org.eclipse.riena.monitor.common.Collectible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregator
implements ICollectingAggregator {
    private IStore store;
    private ISender sender;
    private ICollector[] collectors;
    private boolean started;
    private final BlockingQueue<Runnable> workQueue;
    private final Map<String, Category> categories = new HashMap<String, Category>();
    private final CountDownLatch workSignal = new CountDownLatch(1);
    private static final Logger LOGGER = Activator.getDefault().getLogger(Aggregator.class);

    public Aggregator() {
        this(true);
    }

    protected Aggregator(boolean autoConfig) {
        this.workQueue = new LinkedBlockingQueue<Runnable>();
        this.startWorker();
        if (autoConfig) {
            Inject.extension((String)"org.eclipse.riena.monitor.collectors").useType(ICollectorExtension.class).into((Object)this).andStart(Activator.getDefault().getContext());
            Inject.extension((String)"org.eclipse.riena.monitor.store").expectingMinMax(0, 1).useType(IStoreExtension.class).into((Object)this).andStart(Activator.getDefault().getContext());
            Inject.extension((String)"org.eclipse.riena.monitor.sender").expectingMinMax(0, 1).useType(ISenderExtension.class).into((Object)this).andStart(Activator.getDefault().getContext());
        }
    }

    private void startWorker() {
        new Thread((Runnable)new Worker(), "Client Monitoring Aggregator Worker").start();
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        if (this.collectors.length == 0) {
            LOGGER.log(2, "Client monitoring not started. No collectors defined.");
            return;
        }
        if (this.sender == null) {
            LOGGER.log(2, "Client monitoring not started. No sender defined.");
            return;
        }
        if (this.store == null) {
            LOGGER.log(2, "Client monitoring not started. No store defined.");
            return;
        }
        this.store.setCategories(this.categories);
        this.sender.setCategories(this.categories);
        this.store.open();
        this.sender.start();
        for (ICollector collector : Iter.able((Object[])this.collectors)) {
            collector.start();
        }
        this.started = true;
        this.workSignal.countDown();
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        for (ICollector collector : Iter.able((Object[])this.collectors)) {
            collector.stop();
        }
        this.sender.stop();
        this.store.close();
        this.started = false;
    }

    public synchronized void update(ICollectorExtension[] collectorExtensions) {
        for (ICollector collector : Iter.able((Object[])this.collectors)) {
            collector.stop();
        }
        ArrayList<ICollector> list = new ArrayList<ICollector>(collectorExtensions.length);
        ICollectorExtension[] iCollectorExtensionArray = collectorExtensions;
        int n = collectorExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ICollectorExtension extension = iCollectorExtensionArray[n2];
            Assert.isLegal((!this.categories.containsKey(extension.getCategory()) ? 1 : 0) != 0, (String)("Category " + extension.getCategory() + " is defined twice. Categories must be unique."));
            Category category = new Category(extension.getCategory(), extension.getMaxItems());
            this.categories.put(extension.getCategory(), category);
            ICollector collector = extension.createCollector();
            collector.setCategory(category);
            collector.setAggregator(this);
            list.add(collector);
            ++n2;
        }
        this.collectors = list.toArray(new ICollector[list.size()]);
    }

    public void update(ISenderExtension senderExtension) throws CoreException {
        if (this.sender != null) {
            this.sender.stop();
        }
        this.sender = null;
        if (senderExtension == null) {
            return;
        }
        this.sender = senderExtension.createSender();
        this.sender.setStore(this.store);
    }

    public void update(IStoreExtension storeExtension) throws CoreException {
        if (this.store != null) {
            this.store.flush();
        }
        this.store = null;
        if (storeExtension == null) {
            return;
        }
        this.store = storeExtension.createStore();
    }

    @Override
    public synchronized void collect(final Collectible<?> collectible) {
        boolean elementAdded = this.workQueue.offer(new Runnable(){

            public void run() {
                Aggregator.this.store.collect(collectible);
            }
        });
        Assert.isTrue((boolean)elementAdded);
    }

    @Override
    public synchronized void triggerTransfer(final String category) {
        boolean elementAdded = this.workQueue.offer(new Runnable(){

            public void run() {
                Aggregator.this.store.prepareTransferables(category);
                Aggregator.this.sender.triggerTransfer(category);
            }
        });
        Assert.isTrue((boolean)elementAdded);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        public void run() {
            try {
                Aggregator.this.workSignal.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                while (true) {
                    Runnable runnable = (Runnable)Aggregator.this.workQueue.take();
                    runnable.run();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

