/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubApplicationSwitcherRenderer;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SubApplicationSwitcherRendererTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testGetVisibleItems() {
        SubApplicationSwitcherRenderer renderer = new SubApplicationSwitcherRenderer();
        List visibleItems = (List)ReflectionUtils.invokeHidden((Object)renderer, (String)"getVisibleItems", (Object[])new Object[0]);
        SubApplicationSwitcherRendererTest.assertTrue((boolean)visibleItems.isEmpty());
        SubApplicationNode node1 = new SubApplicationNode();
        node1.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubApplicationItem item1 = new SubApplicationItem((Composite)this.shell, (ISubApplicationNode)node1);
        SubApplicationNode node2 = new SubApplicationNode();
        node2.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubApplicationItem item2 = new SubApplicationItem((Composite)this.shell, (ISubApplicationNode)node2);
        SubApplicationNode node3 = new SubApplicationNode();
        node3.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubApplicationItem item3 = new SubApplicationItem((Composite)this.shell, (ISubApplicationNode)node3);
        ArrayList<SubApplicationItem> items = new ArrayList<SubApplicationItem>(3);
        items.add(item1);
        items.add(item2);
        items.add(item3);
        renderer.setItems(items);
        visibleItems = (List)ReflectionUtils.invokeHidden((Object)renderer, (String)"getVisibleItems", (Object[])new Object[0]);
        SubApplicationSwitcherRendererTest.assertFalse((boolean)visibleItems.isEmpty());
        SubApplicationSwitcherRendererTest.assertEquals((int)3, (int)visibleItems.size());
        SubApplicationSwitcherRendererTest.assertTrue((boolean)visibleItems.contains(item1));
        SubApplicationSwitcherRendererTest.assertTrue((boolean)visibleItems.contains(item2));
        SubApplicationSwitcherRendererTest.assertTrue((boolean)visibleItems.contains(item3));
        node1.addMarker((IMarker)new HiddenMarker());
        node2.addMarker((IMarker)new DisabledMarker());
        node3.addMarker((IMarker)new ErrorMarker());
        visibleItems = (List)ReflectionUtils.invokeHidden((Object)renderer, (String)"getVisibleItems", (Object[])new Object[0]);
        SubApplicationSwitcherRendererTest.assertFalse((boolean)visibleItems.isEmpty());
        SubApplicationSwitcherRendererTest.assertEquals((int)2, (int)visibleItems.size());
        SubApplicationSwitcherRendererTest.assertFalse((boolean)visibleItems.contains(item1));
        SubApplicationSwitcherRendererTest.assertTrue((boolean)visibleItems.contains(item2));
        SubApplicationSwitcherRendererTest.assertTrue((boolean)visibleItems.contains(item3));
    }

    public void testGetItems() {
        SubApplicationSwitcherRenderer renderer = new SubApplicationSwitcherRenderer();
        List items = (List)ReflectionUtils.invokeHidden((Object)renderer, (String)"getItems", (Object[])new Object[0]);
        SubApplicationSwitcherRendererTest.assertTrue((boolean)items.isEmpty());
        List items2 = (List)ReflectionUtils.invokeHidden((Object)renderer, (String)"getItems", (Object[])new Object[0]);
        SubApplicationSwitcherRendererTest.assertTrue((boolean)items2.isEmpty());
        SubApplicationSwitcherRendererTest.assertSame((Object)items, (Object)items2);
        renderer.setItems(null);
        items2 = (List)ReflectionUtils.invokeHidden((Object)renderer, (String)"getItems", (Object[])new Object[0]);
        SubApplicationSwitcherRendererTest.assertTrue((boolean)items2.isEmpty());
        SubApplicationSwitcherRendererTest.assertNotSame((Object)items, (Object)items2);
        SubApplicationNode node1 = new SubApplicationNode();
        SubApplicationItem item1 = new SubApplicationItem((Composite)this.shell, (ISubApplicationNode)node1);
        SubApplicationNode node2 = new SubApplicationNode();
        SubApplicationItem item2 = new SubApplicationItem((Composite)this.shell, (ISubApplicationNode)node2);
        ArrayList<SubApplicationItem> items3 = new ArrayList<SubApplicationItem>(2);
        items3.add(item1);
        items3.add(item2);
        renderer.setItems(items3);
        items2 = (List)ReflectionUtils.invokeHidden((Object)renderer, (String)"getItems", (Object[])new Object[0]);
        SubApplicationSwitcherRendererTest.assertFalse((boolean)items2.isEmpty());
        SubApplicationSwitcherRendererTest.assertEquals((int)2, (int)items2.size());
        SubApplicationSwitcherRendererTest.assertSame(items3, (Object)items2);
    }
}

