/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation.tests;

import junit.framework.TestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidIntermediateDate;

@NonUITestCase
public class ValidIntermediateDateTest
extends TestCase {
    public void testFirstMillenniumPartiallyInvalid() throws Exception {
        ValidIntermediateDate rule = new ValidIntermediateDate("dd.MM.yyyy");
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"01.01.").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"01.01.0").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"01.01.01").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"01.01.010").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"01.01.0101").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"02.02.").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"02.02.2").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"02.02.22").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"02.02.022").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"02.02.222").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"02.02.0002").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"02.02.2222").isOK());
    }

    public void testDatesDDMMYYYY() throws Exception {
        ValidIntermediateDate rule = new ValidIntermediateDate("dd.MM.yyyy");
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"..").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11..").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11.1.").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"11.1.1").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11.1.11").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"55.1.11").isOK());
    }

    public void testDatesDDMMYYYYHHMM() throws Exception {
        ValidIntermediateDate rule = new ValidIntermediateDate("dd.MM.yyyy HH:mm");
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"11.1.1 11:11").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11.1.11 11:11").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11.01.01 :").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11.1.11 :").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"11.1.11 55:11").isOK());
    }

    public void testDatesHHMM() throws Exception {
        ValidIntermediateDate rule = new ValidIntermediateDate("HH:mm");
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11:11").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11:00").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11:0").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11:").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"55:11").isOK());
    }

    public void test601() throws Exception {
        ValidIntermediateDate rule = new ValidIntermediateDate("HH:mm");
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"11:").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"55:").isOK());
    }

    public void testFebruary29th() throws Exception {
        ValidIntermediateDate rule = new ValidIntermediateDate("dd.MM");
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"28.02").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"29.02").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"30.02").isOK());
        rule = new ValidIntermediateDate("MM/dd");
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"02/28").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"02/29").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"02/30").isOK());
        rule = new ValidIntermediateDate("dd.MM.yyyy");
        ValidIntermediateDateTest.assertTrue((boolean)rule.validate((Object)"28.02.2007").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"29.02.2007").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)rule.validate((Object)"30.02.2007").isOK());
    }

    public void testSetInitializationData() throws Exception {
        ValidIntermediateDate validator = new ValidIntermediateDate();
        validator.setInitializationData(null, null, (Object)"dd.MM");
        ValidIntermediateDateTest.assertTrue((boolean)validator.validate((Object)"28.03").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)validator.validate((Object)"32.03").isOK());
        validator = new ValidIntermediateDate();
        validator.setInitializationData(null, null, (Object)"dd.MM.yy");
        ValidIntermediateDateTest.assertFalse((boolean)validator.validate((Object)"28.03").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)validator.validate((Object)"28.03.00").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)validator.validate((Object)"32.03.00").isOK());
        validator = new ValidIntermediateDate();
        validator.setInitializationData(null, null, (Object)"dd.MM.yyyy");
        ValidIntermediateDateTest.assertFalse((boolean)validator.validate((Object)"28.03").isOK());
        ValidIntermediateDateTest.assertTrue((boolean)validator.validate((Object)"28.03.2000").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)validator.validate((Object)"28.03.00").isOK());
        ValidIntermediateDateTest.assertFalse((boolean)validator.validate((Object)"32.03.2000").isOK());
    }
}

