/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.common.IComboEntryFactory;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.databinding.UnboundPropertyWritableList;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboRidget
extends AbstractSWTRidget
implements IComboRidget {
    private final IObservableList rowObservables = new WritableList();
    private final IObservableValue selectionObservable = new WritableValue();
    private final Converter objToStrConverter;
    private final Converter strToObjConverter;
    private final SelectionBindingValidator selectionValidator;
    private final IValueChangeListener valueChangeValidator;
    private Object emptySelection;
    private IObservableList rowObservablesModel;
    private IObservableValue selectionObservableModel;
    private String renderingMethod;
    private Binding listBindingInternal;
    private Binding listBindingExternal;
    private Binding selectionBindingInternal;
    private Binding selectionBindingExternal;

    public ComboRidget() {
        this.selectionObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Object oldValue = event.diff.getOldValue();
                Object newValue = event.diff.getNewValue();
                ComboRidget.this.firePropertyChange("selection", oldValue, newValue);
                ComboRidget.this.disableMandatoryMarkers(ComboRidget.this.hasInput());
            }
        });
        this.objToStrConverter = new ObjectToStringConverter();
        this.strToObjConverter = new StringToObjectConverter();
        this.selectionValidator = new SelectionBindingValidator();
        this.valueChangeValidator = new ValueChangeValidator();
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ComboRidget.this.applyEnabled();
            }
        });
    }

    public Combo getUIControl() {
        return (Combo)super.getUIControl();
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        int style;
        AbstractSWTRidget.assertType(uiControl, Combo.class);
        if (uiControl != null && ((style = ((Combo)uiControl).getStyle()) & 8) == 0) {
            throw new BindingException("Combo must be READ_ONLY");
        }
    }

    @Override
    protected void bindUIControl() {
        Combo control = this.getUIControl();
        if (this.rowObservablesModel != null) {
            DataBindingContext dbc = new DataBindingContext();
            if (control != null) {
                this.listBindingInternal = dbc.bindList(SWTObservables.observeItems((Control)control), this.rowObservables, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE).setConverter((IConverter)this.strToObjConverter), new UpdateListStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)this.objToStrConverter));
                this.listBindingInternal.updateModelToTarget();
                this.applyEnabled();
            }
            this.listBindingExternal = dbc.bindList(this.rowObservables, this.rowObservablesModel, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
            this.selectionBindingExternal = dbc.bindValue(this.selectionObservable, this.selectionObservableModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)this.selectionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    @Override
    protected void unbindUIControl() {
        this.disposeBinding(this.listBindingInternal);
        this.listBindingInternal = null;
        this.disposeBinding(this.listBindingExternal);
        this.listBindingExternal = null;
        this.disposeBinding(this.selectionBindingInternal);
        this.selectionBindingInternal = null;
        this.disposeBinding(this.selectionBindingExternal);
        this.selectionBindingExternal = null;
    }

    public void updateFromModel() {
        this.assertIsBoundToModel();
        super.updateFromModel();
        if (this.listBindingInternal != null && this.listBindingInternal.getModel() instanceof UnboundPropertyWritableList) {
            ((UnboundPropertyWritableList)this.listBindingInternal.getModel()).updateFromBean();
        }
        this.selectionValidator.enableBinding(false);
        this.listBindingExternal.updateModelToTarget();
        if (this.listBindingInternal != null) {
            this.listBindingInternal.updateModelToTarget();
        }
        this.selectionValidator.enableBinding(true);
        this.selectionBindingExternal.updateModelToTarget();
        if (this.selectionBindingInternal != null) {
            this.selectionBindingInternal.updateModelToTarget();
        }
    }

    public void bindToModel(IObservableList listObservableValue, Class<? extends Object> rowBeanClass, String renderingMethod, IObservableValue selectionObservableValue) {
        this.unbindUIControl();
        this.rowObservablesModel = listObservableValue;
        this.renderingMethod = renderingMethod;
        this.selectionObservableModel = selectionObservableValue;
        this.bindUIControl();
    }

    public void bindToModel(Object listBean, String listPropertyName, Class<? extends Object> rowBeanClass, String renderingMethod, Object selectionBean, String selectionPropertyName) {
        UnboundPropertyWritableList listObservableValue = new UnboundPropertyWritableList(listBean, listPropertyName);
        IObservableValue selectionObservableValue = BeansObservables.observeValue((Object)selectionBean, (String)selectionPropertyName);
        this.bindToModel((IObservableList)listObservableValue, rowBeanClass, renderingMethod, selectionObservableValue);
    }

    public void bindToModel(Object listBean, String listPropertyName, Class<? extends Object> rowBeanClass, String renderingMethod, Object selectionBean, String selectionPropertyName, IComboEntryFactory entryFactory) {
        throw new UnsupportedOperationException();
    }

    public Object getEmptySelectionItem() {
        return this.emptySelection;
    }

    public IObservableList getObservableList() {
        return this.rowObservables;
    }

    public Object getSelection() {
        Object selection = this.selectionObservable.getValue();
        return selection == this.emptySelection ? null : selection;
    }

    public int getSelectionIndex() {
        int result = -1;
        Object selection = this.selectionObservable.getValue();
        if (this.emptySelection != selection) {
            result = this.rowObservables.indexOf(selection);
        }
        return result;
    }

    public boolean isAddable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    public boolean isListMutable() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadonly() {
        throw new UnsupportedOperationException();
    }

    public void setAddable(boolean addable) {
        throw new UnsupportedOperationException();
    }

    public void setEmptySelectionItem(Object emptySelectionItem) {
        this.emptySelection = emptySelectionItem;
    }

    public void setListMutable(boolean mutable) {
        throw new UnsupportedOperationException();
    }

    public void setReadonly(boolean readonly) {
        throw new UnsupportedOperationException();
    }

    public void setSelection(Object newSelection) {
        this.assertIsBoundToModel();
        Object oldSelection = this.selectionObservable.getValue();
        if (oldSelection != newSelection) {
            if (newSelection == null || !this.rowObservables.contains(newSelection)) {
                if (this.getUIControl() != null) {
                    this.getUIControl().deselectAll();
                }
                this.selectionObservable.setValue(null);
            } else {
                this.selectionObservable.setValue(newSelection);
            }
        }
    }

    public void setSelection(int index) {
        if (index == -1) {
            this.setSelection(null);
        } else {
            Object newSelection = this.rowObservables.get(index);
            this.setSelection(newSelection);
        }
    }

    private void applyEnabled() {
        if (this.isEnabled()) {
            this.bindControlToSelectionAndUpdate();
        } else {
            this.unbindControlFromSelectionAndClear();
        }
    }

    private void assertIsBoundToModel() {
        if (this.rowObservablesModel == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindControlToSelectionAndUpdate() {
        Combo control = this.getUIControl();
        if (control != null && this.listBindingInternal != null) {
            this.listBindingInternal.updateModelToTarget();
            ISWTObservableValue controlSelection = SWTObservables.observeSelection((Control)control);
            controlSelection.addValueChangeListener(this.valueChangeValidator);
            DataBindingContext dbc = new DataBindingContext();
            this.selectionBindingInternal = dbc.bindValue((IObservableValue)controlSelection, this.selectionObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)this.strToObjConverter).setAfterGetValidator((IValidator)this.selectionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)this.objToStrConverter));
            this.selectionBindingInternal.updateModelToTarget();
        }
    }

    private void disposeBinding(Binding binding) {
        if (binding != null && !binding.isDisposed()) {
            binding.dispose();
        }
    }

    private String getItemFromValue(Object value) {
        Object valueObject = value;
        if (value != null && this.renderingMethod != null) {
            valueObject = ReflectionUtils.invoke((Object)value, (String)this.renderingMethod, null);
        }
        return String.valueOf(valueObject);
    }

    private Object getValueFromItem(String item) {
        String[] items = this.getUIControl().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return this.rowObservables.get(i);
            }
            ++i;
        }
        return item;
    }

    private boolean hasInput() {
        Object selection = this.selectionObservable.getValue();
        return selection != null && selection != this.emptySelection;
    }

    private void unbindControlFromSelectionAndClear() {
        Combo control = this.getUIControl();
        if (control != null && !this.isEnabled()) {
            this.disposeBinding(this.selectionBindingInternal);
            this.selectionBindingInternal = null;
            if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
                control.removeAll();
            }
        }
    }

    private final class ObjectToStringConverter
    extends Converter {
        public ObjectToStringConverter() {
            super(Object.class, String.class);
        }

        public Object convert(Object fromObject) {
            return ComboRidget.this.getItemFromValue(fromObject);
        }
    }

    private final class SelectionBindingValidator
    implements IValidator {
        private boolean isEnabled = true;

        private SelectionBindingValidator() {
        }

        public IStatus validate(Object value) {
            IStatus result = Status.OK_STATUS;
            if (!this.isEnabled || ComboRidget.this.isOutputOnly()) {
                result = Status.CANCEL_STATUS;
            }
            return result;
        }

        void enableBinding(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }
    }

    private final class StringToObjectConverter
    extends Converter {
        public StringToObjectConverter() {
            super(String.class, Object.class);
        }

        public Object convert(Object fromObject) {
            return ComboRidget.this.getValueFromItem((String)fromObject);
        }
    }

    private final class ValueChangeValidator
    implements IValueChangeListener {
        private volatile boolean changing = false;

        private ValueChangeValidator() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            if (this.changing || !ComboRidget.this.isOutputOnly()) {
                return;
            }
            this.changing = true;
            try {
                int index;
                Combo combo = ComboRidget.this.getUIControl();
                String oldValue = (String)event.diff.getOldValue();
                int n = index = oldValue != null ? combo.indexOf(oldValue) : -1;
                if (index > -1) {
                    combo.select(index);
                } else {
                    combo.deselectAll();
                }
            }
            finally {
                this.changing = false;
            }
        }
    }
}

