/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.BeanPropertyAccessor;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;
import org.eclipse.riena.ui.ridgets.databinding.IUnboundPropertyObservable;

public class UnboundPropertyWritableList
extends WritableList
implements IUnboundPropertyObservable {
    private final Object bean;
    private final PropertyDescriptor propertyDescriptor;

    public UnboundPropertyWritableList(Object listBean, String listPropertyName) {
        Assert.isNotNull((Object)listBean, (String)("bound property for " + listPropertyName + " cannot be null."));
        try {
            this.propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)listBean, (String)listPropertyName);
            if (this.propertyDescriptor == null) {
                throw new UIBindingFailure("Could not read propertyDescriptor " + listPropertyName + " in " + listBean);
            }
            this.bean = listBean;
        }
        catch (IllegalAccessException e) {
            throw new UIBindingFailure("Could not read property '" + listPropertyName + "' of bean " + listBean + ".", e);
        }
        catch (InvocationTargetException e) {
            throw new UIBindingFailure("Could not read property '" + listPropertyName + "' of bean " + listBean + ".", e);
        }
        catch (NoSuchMethodException e) {
            throw new UIBindingFailure("Could not read property '" + listPropertyName + "' of bean " + listBean + ".", e);
        }
        this.updateFromBean();
    }

    public void updateFromBean() {
        Object value = BeanPropertyAccessor.getPropertyValue((Object)this.bean, (PropertyDescriptor)this.propertyDescriptor);
        if (value == null) {
            this.clear();
        } else if (value instanceof Collection) {
            this.updateWrappedList(new ArrayList((Collection)value));
        } else {
            throw new UIBindingFailure("The property '" + this.propertyDescriptor.getName() + "'is not a java.util.Collection.");
        }
    }

    public void updateToBean() {
        ArrayList newValue = new ArrayList(this);
        BeanPropertyAccessor.setPropertyValue((Object)this.bean, (PropertyDescriptor)this.propertyDescriptor, newValue);
    }

    public void add(int index, Object element) {
        super.add(index, element);
        this.updateToBean();
    }

    public Object set(int index, Object element) {
        Object returnValue = super.set(index, element);
        this.updateToBean();
        return returnValue;
    }

    public Object remove(int index) {
        Object returnValue = super.remove(index);
        this.updateToBean();
        return returnValue;
    }
}

