/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.Collection;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.riena.ui.ridgets.marker.AbstractMessageMarkerViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatuslineMessageMarkerViewer
extends AbstractMessageMarkerViewer {
    private String statuslineMessage;
    private String originalStatuslineMessage;
    private IStatuslineRidget statusline = null;
    private PropertyChangeListener markerPropertyChangeListener = new MarkerPropertyChangeListener();
    private IFocusListener ridgetFocusListener = new RidgetFocusListener();

    public StatuslineMessageMarkerViewer(IStatuslineRidget statuslineRidget) {
        this.statusline = statuslineRidget;
    }

    @Override
    public void addRidget(IMarkableRidget markableRidget) {
        super.addRidget(markableRidget);
        markableRidget.addPropertyChangeListener(this.markerPropertyChangeListener);
        markableRidget.addFocusListener(this.ridgetFocusListener);
    }

    @Override
    protected void showMessages(IMarkableRidget markableRidget) {
        if (markableRidget.hasFocus()) {
            Collection<IMessageMarker> messageMarker = this.getMessageMarker(markableRidget);
            String message = this.constructMessage(messageMarker).trim();
            Severity severity = this.getMaxSeverity(messageMarker);
            if (message.length() > 0 && this.isVisible()) {
                this.setStatuslineMessage(message, severity);
            } else {
                this.hideMessages(markableRidget);
            }
        }
    }

    @Override
    protected void hideMessages(IMarkableRidget ridget) {
        if (ridget.hasFocus()) {
            this.resetStatuslineMessage();
        }
    }

    private void setStatuslineMessage(String message, Severity severity) {
        if (this.getStatusLine() != null) {
            if (this.statuslineMessage == null) {
                this.originalStatuslineMessage = this.getStatusLine().getMessage();
            }
            switch (severity) {
                case ERROR: {
                    this.getStatusLine().error(message);
                    break;
                }
                case WARNING: {
                    this.getStatusLine().warning(message);
                    break;
                }
                case INFO: {
                    this.getStatusLine().info(message);
                    break;
                }
                default: {
                    this.getStatusLine().clear();
                    this.getStatusLine().setMessage(message);
                }
            }
            this.statuslineMessage = message;
        }
    }

    private void resetStatuslineMessage() {
        if (this.getStatusLine() != null) {
            if (this.statuslineMessage != null && this.statuslineMessage.equals(this.getStatusLine().getMessage())) {
                this.getStatusLine().setMessage(this.originalStatuslineMessage);
            }
            this.statuslineMessage = null;
        }
    }

    private String constructMessage(Collection<IMessageMarker> messageMarker) {
        StringWriter sw = new StringWriter();
        IMessageMarker nextMarker2 = null;
        if (messageMarker != null) {
            for (IMessageMarker nextMarker2 : messageMarker) {
                if (sw.toString().trim().length() > 0) {
                    sw.write(" ");
                }
                if (nextMarker2.getMessage() == null) continue;
                sw.write(nextMarker2.getMessage());
            }
        }
        return sw.toString().trim();
    }

    private Severity getMaxSeverity(Collection<IMessageMarker> messageMarkers) {
        Severity severity = Severity.NONE;
        for (IMessageMarker messageMarker : messageMarkers) {
            if (!(messageMarker instanceof ErrorMarker) || !severity.isLower(Severity.ERROR)) continue;
            severity = Severity.ERROR;
        }
        return severity;
    }

    IStatuslineRidget getStatusLine() {
        return this.statusline;
    }

    private class MarkerPropertyChangeListener
    implements PropertyChangeListener {
        private MarkerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("marker") && evt.getSource() instanceof IMarkableRidget && ((IMarkableRidget)evt.getSource()).hasFocus()) {
                StatuslineMessageMarkerViewer.this.showMessages((IMarkableRidget)evt.getSource());
            }
        }
    }

    private class RidgetFocusListener
    implements IFocusListener {
        private RidgetFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            if (event.getNewFocusOwner() instanceof IMarkableRidget) {
                StatuslineMessageMarkerViewer.this.showMessages((IMarkableRidget)event.getNewFocusOwner());
            }
        }

        public void focusLost(FocusEvent event) {
            if (event.getOldFocusOwner() instanceof IMarkableRidget) {
                StatuslineMessageMarkerViewer.this.resetStatuslineMessage();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Severity {
        NONE(0),
        INFO(1),
        WARNING(2),
        ERROR(3);

        private int index;

        private Severity(int index) {
            this.index = index;
        }

        boolean isLower(Severity other) {
            return this.index < other.index;
        }
    }
}

