/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree;

import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.tree.ITreeNode;

public class DefaultTreeNode
implements ITreeNode {
    private DefaultTreeNode parent;
    protected Vector<DefaultTreeNode> children = new Vector();
    private Object userObject;

    public DefaultTreeNode() {
        this(null);
    }

    public DefaultTreeNode(Object userObject) {
        this(null, userObject);
    }

    public DefaultTreeNode(DefaultTreeNode parent, Object userObject) {
        this.setUserObject(userObject);
        this.setParent(parent);
    }

    public ITreeNode getChildAt(int childIndex) {
        Assert.isNotNull(this.children, (String)"node has no children");
        return this.children.elementAt(childIndex);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(ITreeNode node) {
        Assert.isNotNull((Object)node, (String)"missing node argument");
        if (!this.isNodeChild(node)) {
            return -1;
        }
        return this.children.indexOf(node);
    }

    public boolean isNodeChild(ITreeNode aNode) {
        boolean retValue = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retValue;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        if (this.userObject == null) {
            return "";
        }
        return this.userObject.toString();
    }

    public void add(DefaultTreeNode newChild) {
        this.insert(newChild, this.children.size());
    }

    public void insert(DefaultTreeNode newChild, int childIndex) {
        DefaultTreeNode oldParent = (DefaultTreeNode)newChild.getParent();
        if (oldParent != null && oldParent != this) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        DefaultTreeNode child = (DefaultTreeNode)this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void removeFromParent() {
        DefaultTreeNode myparent = (DefaultTreeNode)this.getParent();
        if (myparent != null) {
            myparent.remove(this);
        }
    }

    public void remove(DefaultTreeNode aChild) {
        Assert.isNotNull((Object)aChild, (String)"missing aChild argument");
        Assert.isTrue((boolean)this.isNodeChild(aChild), (String)"aChild argument is not a child");
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            this.remove(i);
            --i;
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public ITreeNode getParent() {
        return this.parent;
    }

    public void setParent(DefaultTreeNode parent) {
        this.parent = parent;
    }

    public int getLevel() {
        if (this.getParent() == null) {
            return 0;
        }
        return this.getParent().getLevel() + 1;
    }
}

