/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class ChoiceSubModuleController
extends SubModuleController {
    private String[] carPlates = new String[]{"JM5B0ND", "1 SPY", "MNY PNY", "BN D07", "Q RULE2", "MI64EVR"};

    public ChoiceSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        final CarConfig carConfig = new CarConfig();
        final ISingleChoiceRidget compositeCarModel = (ISingleChoiceRidget)this.getRidget("compositeCarModel");
        compositeCarModel.bindToModel((IObservableList)this.toList((Object[])CarModels.values()), BeansObservables.observeValue((Object)((Object)carConfig), (String)"model"));
        compositeCarModel.addMarker((IMarker)new MandatoryMarker());
        compositeCarModel.updateFromModel();
        final IMultipleChoiceRidget compositeCarExtras = (IMultipleChoiceRidget)this.getRidget("compositeCarExtras");
        String[] labels = new String[]{"Front Machine Guns", "Self Destruct Button", "Underwater Package", "Park Distance Control System"};
        compositeCarExtras.bindToModel((List)this.toList((Object[])CarOptions.values()), Arrays.asList(labels), (Object)carConfig, "options");
        compositeCarExtras.updateFromModel();
        final ISingleChoiceRidget compositeCarWarranty = (ISingleChoiceRidget)this.getRidget("compositeCarWarranty");
        compositeCarWarranty.bindToModel((IObservableList)this.toList((Object[])CarWarranties.values()), BeansObservables.observeValue((Object)((Object)carConfig), (String)"warranty"));
        compositeCarWarranty.addMarker((IMarker)new MandatoryMarker());
        compositeCarWarranty.updateFromModel();
        final IMultipleChoiceRidget compositeCarPlates = (IMultipleChoiceRidget)this.getRidget("compositeCarPlates");
        compositeCarPlates.bindToModel((IObservableList)this.toList(this.carPlates), PojoObservables.observeList((Object)((Object)carConfig), (String)"plates"));
        compositeCarPlates.addMarker((IMarker)new MandatoryMarker());
        compositeCarPlates.updateFromModel();
        ITextRidget txtPrice = (ITextRidget)this.getRidget("txtPrice");
        txtPrice.setOutputOnly(true);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue(BeansObservables.observeValue((Object)txtPrice, (String)"text"), BeansObservables.observeValue((Object)((Object)carConfig), (String)"price"), null, null);
        IActionRidget buttonPreset = (IActionRidget)this.getRidget("buttonPreset");
        buttonPreset.setText("&Quick Config");
        buttonPreset.addListener(new IActionListener(){

            public void callback() {
                compositeCarModel.setSelection((Object)CarModels.BMW);
                compositeCarExtras.setSelection(Arrays.asList(CarOptions.PDCS));
                compositeCarWarranty.setSelection((Object)CarWarranties.EXTENDED);
                compositeCarPlates.setSelection(Arrays.asList(ChoiceSubModuleController.this.carPlates[0]));
            }
        });
        IActionRidget buttonReset = (IActionRidget)this.getRidget("buttonReset");
        buttonReset.setText("&Reset");
        buttonReset.addListener(new IActionListener(){

            public void callback() {
                carConfig.reset();
                compositeCarModel.updateFromModel();
                compositeCarExtras.updateFromModel();
                compositeCarWarranty.updateFromModel();
                compositeCarPlates.updateFromModel();
            }
        });
    }

    private WritableList toList(Object[] values) {
        return new WritableList(Arrays.asList(values), Object.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CarConfig
    extends AbstractBean {
        public static final String PROP_MODEL = "model";
        public static final String PROP_OPTIONS = "options";
        public static final String PROP_WARRANTY = "warranty";
        public static final String PROP_PLATES = "plates";
        public static final String PROP_PRICE = "price";
        private CarModels model;
        private List<CarOptions> options = new ArrayList<CarOptions>();
        private CarWarranties warranty;
        private List<String> plates = new ArrayList<String>();

        private CarConfig() {
        }

        public CarModels getModel() {
            return this.model;
        }

        public void setModel(CarModels model) {
            this.model = model;
            this.firePropertyChanged(PROP_MODEL, (Object)this.model, (Object)this.model);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public List<CarOptions> getOptions() {
            return Collections.unmodifiableList(this.options);
        }

        public void setOptions(List<CarOptions> options) {
            this.options = new ArrayList<CarOptions>(options);
            this.firePropertyChanged(PROP_OPTIONS, this.options, this.options);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public CarWarranties getWarranty() {
            return this.warranty;
        }

        public void setWarranty(CarWarranties warranty) {
            this.warranty = warranty;
            this.firePropertyChanged(PROP_WARRANTY, (Object)this.warranty, (Object)this.warranty);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public List<String> getPlates() {
            return Collections.unmodifiableList(this.plates);
        }

        public void setPlates(List<String> plates) {
            this.plates = new ArrayList<String>(plates);
            this.firePropertyChanged(PROP_PLATES, this.plates, this.plates);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public void reset() {
            this.setModel(null);
            this.setOptions(new ArrayList<CarOptions>());
            this.setWarranty(null);
            this.setPlates(new ArrayList<String>());
        }

        public long getPrice() {
            long price = 0L;
            if (this.model != null) {
                price += 100000L;
            }
            price += (long)this.options.size() * 25000L;
            if (this.warranty == CarWarranties.EXTENDED) {
                price += 10000L;
            }
            return price += (long)this.plates.size() * 200L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CarModels {
        ASTON_MARTIN("Aston Martin V-12 Vanquish"),
        LOTUS("Lotus Esprit Turbo"),
        BMW("BMW Z8");

        private String label;

        private CarModels(String label) {
            Assert.isNotNull((Object)label);
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CarOptions {
        FRONT_GUNS,
        SELF_DESTRUCT,
        UNDERWATER,
        PDCS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CarWarranties {
        STANDARD,
        EXTENDED;


        public String toString() {
            char[] result = super.toString().toLowerCase().toCharArray();
            result[0] = Character.toUpperCase(result[0]);
            return String.valueOf(result);
        }
    }
}

