/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.Collection;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeUtility;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterContainer;
import org.eclipse.riena.ui.filter.impl.UIFilterProviderAccessor;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class FilterExampleSubModuleController
extends SubModuleController {
    private static final String SELECTED_TEXT = "deactivate";
    private static final String NOT_SELECTED_TEXT = "activate";

    public void configureRidgets() {
        super.configureRidgets();
        IToggleButtonRidget navigationAction = (IToggleButtonRidget)this.getRidget("navigationBtn");
        this.updateToggleText(navigationAction);
        navigationAction.addListener(new IActionListener(){

            public void callback() {
                FilterExampleSubModuleController.this.doFilter(FilterId.NAVIGATION, "navigationBtn");
            }
        });
        IToggleButtonRidget menuToolAction = (IToggleButtonRidget)this.getRidget("menuToolItemBtn");
        this.updateToggleText(menuToolAction);
        menuToolAction.addListener(new IActionListener(){

            public void callback() {
                FilterExampleSubModuleController.this.doFilter(FilterId.MENUITEM, "menuToolItemBtn");
            }
        });
        IToggleButtonRidget ridgetAction = (IToggleButtonRidget)this.getRidget("ridgetBtn");
        this.updateToggleText(ridgetAction);
        ridgetAction.addListener(new IActionListener(){

            public void callback() {
                FilterExampleSubModuleController.this.doFilter(FilterId.RIDGET, "ridgetBtn");
            }
        });
        IToggleButtonRidget ridgetDisableAction = (IToggleButtonRidget)this.getRidget("ridgetDisableBtn");
        this.updateToggleText(ridgetAction);
        ridgetDisableAction.addListener(new IActionListener(){

            public void callback() {
                FilterExampleSubModuleController.this.doFilter(FilterId.RIDGET_DISABLE, "ridgetDisableBtn");
            }
        });
        IToggleButtonRidget ridgetHideAction = (IToggleButtonRidget)this.getRidget("ridgetHideBtn");
        this.updateToggleText(ridgetAction);
        ridgetHideAction.addListener(new IActionListener(){

            public void callback() {
                FilterExampleSubModuleController.this.doFilter(FilterId.RIDGET_HIDE, "ridgetHideBtn");
            }
        });
        IToggleButtonRidget ridget01Action = (IToggleButtonRidget)this.getRidget("ridget01Btn");
        this.updateToggleText(ridgetAction);
        ridget01Action.addListener(new IActionListener(){

            public void callback() {
                FilterExampleSubModuleController.this.doFilter(FilterId.RIDGET_01, "ridget01Btn");
            }
        });
        MySampleBean sampleBean = new MySampleBean();
        ITextRidget sampleText = (ITextRidget)this.getRidget("sampleText");
        sampleText.setMandatory(true);
        sampleText.bindToModel((Object)sampleBean, "text");
        sampleText.updateFromModel();
    }

    private void doFilter(FilterId filterId, String buttonRidgetId) {
        IToggleButtonRidget menuToolAction = (IToggleButtonRidget)this.getRidget(buttonRidgetId);
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        IUIFilterContainer container = UIFilterProviderAccessor.getFilterProvider().provideFilter(filterId.toString());
        IUIFilter filter = container.getFilter();
        Collection targetNodeIds = container.getFilterTargetNodeIds();
        for (String targetNodeId : targetNodeIds) {
            INavigationNode node = NavigationNodeUtility.findNodeLongId((String)targetNodeId, (INavigationNode)applNode);
            if (menuToolAction.isSelected()) {
                node.addFilter(filter);
                continue;
            }
            node.removeFilter(filter.getFilterID());
        }
        this.updateToggleText(menuToolAction);
    }

    private void updateToggleText(IToggleButtonRidget toggle) {
        if (toggle.isSelected()) {
            toggle.setText(SELECTED_TEXT);
        } else {
            toggle.setText(NOT_SELECTED_TEXT);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilterId {
        MENUITEM("rienaExample.menuToolBar"),
        NAVIGATION("rienaExample.navigation"),
        RIDGET("rienaExample.ridget"),
        RIDGET_01("rienaExample.ridget01"),
        RIDGET_HIDE("rienaExample.ridgetHide"),
        RIDGET_DISABLE("rienaExample.ridgetDisable");

        private final String id;

        private FilterId(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    private static class MySampleBean {
        private String text = "";

        private MySampleBean() {
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

