/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.SingleSelectionListBean;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class TextDateSubModuleController
extends SubModuleController {
    private FontManager fontManager;
    private IDateTextRidget justEights;

    public void configureRidgets() {
        String[] ids = new String[]{"dd.MM.yyyy", "dd.MM.yy", "dd.MM", "MM.yyyy", "yyyy", "HH:mm:ss", "HH:mm", "dd.MM.yyyy_HH:mm"};
        DataBindingContext dbc = new DataBindingContext();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.bind(dbc, id);
            ++n2;
        }
        this.bindToModel("dd.MM.yyyy", new StringBean("01.10.2008"));
        this.bindToModel("dd.MM.yy", new StringBean("01.10.08"));
        this.bindToModel("dd.MM", new StringBean("01.10"));
        this.bindToModel("MM.yyyy", new StringBean("10.2008"));
        this.bindToModel("yyyy", new StringBean("2008"));
        this.bindToModel("HH:mm:ss", new StringBean("23:55:00"));
        this.bindToModel("HH:mm", new StringBean("23:55"));
        this.bindToModel("dd.MM.yyyy_HH:mm", new StringBean("01.10.2008 23:55"));
        this.justEights = (IDateTextRidget)this.getRidget("inJustEights");
        this.justEights.setFormat("dd.MM.yyyy");
        this.justEights.setOutputOnly(true);
        this.justEights.bindToModel((Object)new StringBean("88.88.8888"), "value");
        this.justEights.updateFromModel();
        IDateTextRidget justSpaces = (IDateTextRidget)this.getRidget("inJustSpaces");
        justSpaces.setFormat("dd.MM.yyyy");
        justSpaces.setOutputOnly(true);
        justSpaces.bindToModel((Object)new StringBean("  .  .    "), "value");
        justSpaces.updateFromModel();
        this.fontManager = new FontManager(PlatformUI.getWorkbench().getDisplay());
        this.fontManager.addRidget((IRidget)this.justEights);
        this.fontManager.addRidget((IRidget)justSpaces);
        IComboRidget comboFonts = (IComboRidget)this.getRidget("comboFonts");
        SingleSelectionListBean fonts = new SingleSelectionListBean(new Object[]{"Arial", "Courier New", "Verdana"});
        fonts.setSelection((Object)"Arial");
        comboFonts.bindToModel((Object)fonts, "values", String.class, null, (Object)fonts, "selection");
        comboFonts.addPropertyChangeListener("selection", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = (String)evt.getNewValue();
                TextDateSubModuleController.this.fontManager.setName(name);
            }
        });
        comboFonts.updateFromModel();
        SingleSelectionListBean sizes = new SingleSelectionListBean(new Object[]{"6", "7", "8", "9", "10", "11", "12"});
        sizes.setSelection((Object)"9");
        IComboRidget comboSizes = (IComboRidget)this.getRidget("comboSizes");
        comboSizes.bindToModel((Object)sizes, "values", String.class, null, (Object)sizes, "selection");
        comboSizes.addPropertyChangeListener("selection", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String size = (String)evt.getNewValue();
                TextDateSubModuleController.this.fontManager.setSize(size);
            }
        });
        comboSizes.updateFromModel();
    }

    public void afterBind() {
        ((Control)this.justEights.getUIControl()).addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TextDateSubModuleController.this.fontManager != null) {
                    TextDateSubModuleController.this.fontManager.dispose();
                    TextDateSubModuleController.this.fontManager = null;
                }
            }
        });
    }

    private void bind(DataBindingContext dbc, String id) {
        IRidget inputRidget = this.getRidget("in" + id);
        ITextRidget outputRidget = (ITextRidget)this.getRidget("out" + id);
        outputRidget.setOutputOnly(true);
        outputRidget.setEnabled(false);
        dbc.bindValue(BeansObservables.observeValue((Object)inputRidget, (String)"text"), BeansObservables.observeValue((Object)outputRidget, (String)"text"), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
    }

    private void bindToModel(String id, StringBean value) {
        IDateTextRidget ridget = (IDateTextRidget)this.getRidget("in" + id);
        ridget.setFormat(id.replace('_', ' '));
        ridget.bindToModel((Object)value, "value");
        ridget.updateFromModel();
    }

    private static final class FontManager {
        private final Display display;
        private Font font;
        private String name;
        private String size;
        private Set<IRidget> ridgets;

        FontManager(Display display) {
            Assert.isNotNull((Object)display);
            this.display = display;
            this.name = "";
            this.size = "";
            this.ridgets = new HashSet<IRidget>();
        }

        void addRidget(IRidget control) {
            this.ridgets.add(control);
        }

        public synchronized void dispose() {
            this.ridgets.clear();
            if (this.font != null) {
                this.font.dispose();
                this.font = null;
            }
        }

        void setName(String name) {
            Assert.isNotNull((Object)name);
            if (!this.name.equals(name)) {
                this.name = name;
                this.updateControls();
            }
        }

        void setSize(String size) {
            Assert.isNotNull((Object)size);
            if (!this.size.equals(size)) {
                this.size = size;
                this.updateControls();
            }
        }

        private synchronized void updateControls() {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.display, this.name, Integer.valueOf(this.size).intValue(), 0);
            for (IRidget ridget : this.ridgets) {
                Object control = ridget.getUIControl();
                if (!(control instanceof Control)) continue;
                ((Control)control).setFont(this.font);
            }
        }
    }
}

