/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.internal.core.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T newInstance(String className, Object ... args) {
        Assert.isNotNull((Object)className, (String)"className must be given!");
        try {
            return ReflectionUtils.newInstance(false, ReflectionUtils.loadClass(className), args);
        }
        catch (Exception e) {
            throw new ReflectionFailure("Error creating instance for " + className + " with parameters " + Arrays.asList(args) + "!", e);
        }
    }

    public static <T> T newInstanceHidden(String className, Object ... args) {
        Assert.isNotNull((Object)className, (String)"className must be given!");
        try {
            return ReflectionUtils.newInstance(true, ReflectionUtils.loadClass(className), args);
        }
        catch (Exception e) {
            throw new ReflectionFailure("Error creating instance for " + className + " with parameters " + Arrays.asList(args) + "!", e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        return ReflectionUtils.newInstance(false, clazz, args);
    }

    public static <T> T newInstanceHidden(Class<T> clazz, Object ... args) {
        return ReflectionUtils.newInstance(true, clazz, args);
    }

    private static <T> T newInstance(boolean open, Class<T> clazz, Object ... args) {
        Assert.isNotNull(clazz, (String)"clazz must be given!");
        try {
            Class<? extends Object>[] clazzes = ReflectionUtils.classesPrimitiveFromObjects(args);
            Constructor<T> constructor = ReflectionUtils.findMatchingConstructor(open, clazz, clazzes);
            if (constructor == null) {
                clazzes = ReflectionUtils.classesFromObjects(args);
                constructor = ReflectionUtils.findMatchingConstructor(open, clazz, clazzes);
            }
            if (open) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw new ReflectionFailure("Error creating instance for " + clazz.getName() + " with parameters " + Arrays.asList(args) + "!", t);
        }
    }

    public static <T> T newInstance(String interfaceName, InvocationHandler invocationHandler) {
        Assert.isNotNull((Object)interfaceName, (String)"interfaceName must be given!");
        Assert.isNotNull((Object)invocationHandler, (String)"invocationHandler must be given!");
        try {
            return (T)ReflectionUtils.newInstance(Class.forName(interfaceName), invocationHandler);
        }
        catch (Exception e) {
            throw new ReflectionFailure("Error creating proxy instance for " + interfaceName + " !", e);
        }
    }

    public static <T> T newInstance(Class<T> interfaze, InvocationHandler invocationHandler) {
        Assert.isNotNull(interfaze, (String)"interfaceName must be given");
        Assert.isNotNull((Object)invocationHandler, (String)"invocationHandler must be given");
        Class<?> proxyClass = Proxy.getProxyClass(interfaze.getClassLoader(), interfaze);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
            Object object = constructor.newInstance(invocationHandler);
            return (T)object;
        }
        catch (Throwable throwable) {
            throw new ReflectionFailure("Error creating proxy instance for " + interfaze.getName() + " !", throwable);
        }
    }

    public static <T> T invoke(Object instance, String methodName, Object ... args) {
        return ReflectionUtils.invoke(false, instance, methodName, args);
    }

    public static <T> T invokeHidden(Object instance, String methodName, Object ... args) {
        return ReflectionUtils.invoke(true, instance, methodName, args);
    }

    public static <T extends Throwable> Object invoke(Object instance, String methodName, Class<T> expectedException, Object ... args) throws T {
        Assert.isNotNull(expectedException, (String)"expectedException should not be null!");
        try {
            return ReflectionUtils.invoke(instance, methodName, args);
        }
        catch (InvocationTargetFailure e) {
            if (expectedException.isAssignableFrom(e.getCause().getClass())) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public static <T extends Throwable> Object invokeHidden(Object instance, String methodName, Class<T> expectedException, Object ... args) throws T {
        Assert.isNotNull(expectedException, (String)"expectedException should not be null!");
        try {
            return ReflectionUtils.invokeHidden(instance, methodName, args);
        }
        catch (InvocationTargetFailure e) {
            if (expectedException.isAssignableFrom(e.getCause().getClass())) {
                throw e.getCause();
            }
            throw e;
        }
    }

    private static <T> T invoke(boolean open, Object instance, String methodName, Object ... args) {
        Assert.isNotNull((Object)instance, (String)"instance must be given!");
        Assert.isNotNull((Object)methodName, (String)"methodName must be given!");
        Class<?> clazz = ReflectionUtils.getClass(instance);
        while (clazz != null) {
            Class<? extends Object>[] clazzes = ReflectionUtils.classesPrimitiveFromObjects(args);
            Method method = ReflectionUtils.findMatchingMethod(open, clazz, methodName, clazzes);
            if (method == null) {
                clazzes = ReflectionUtils.classesFromObjects(args);
                method = ReflectionUtils.findMatchingMethod(open, clazz, methodName, clazzes);
            }
            if (method != null) {
                if (open) {
                    method.setAccessible(true);
                }
                try {
                    return (T)method.invoke(instance, args);
                }
                catch (InvocationTargetException ite) {
                    throw new InvocationTargetFailure("Calling #" + methodName + " on " + instance + " failed.", ite.getTargetException());
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionFailure("Calling #" + methodName + " on " + instance + " failed.", e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionFailure("Calling #" + methodName + " on " + instance + " failed.", e);
                }
            }
            clazz = clazz.getSuperclass();
        }
        throw new ReflectionFailure("Could not invoke hidden method " + methodName + " on " + instance.getClass().getName() + "!");
    }

    public static void setHidden(Object instance, String fieldName, Object value) {
        Assert.isNotNull((Object)instance, (String)"instance must be given!");
        Assert.isNotNull((Object)fieldName, (String)"fieldName must be given!");
        Class<?> clazz = ReflectionUtils.getClass(instance);
        try {
            Field field = ReflectionUtils.getDeepField(clazz, fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new ReflectionFailure("Could not set hidden field " + fieldName + " on " + clazz.getName() + "!", e);
        }
    }

    public static <T> T getHidden(Object instance, String fieldName) {
        Assert.isNotNull((Object)instance, (String)"instance must be given!");
        Assert.isNotNull((Object)fieldName, (String)"fieldName must be given!");
        Class<?> clazz = ReflectionUtils.getClass(instance);
        try {
            Field field = ReflectionUtils.getDeepField(clazz, fieldName);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Exception e) {
            throw new ReflectionFailure("Could not get hidden field " + fieldName + " on " + clazz.getName() + "!", e);
        }
    }

    public static <T> T newLazyInstance(Class<T> interfaze, Class<? extends T> clazz, Object ... args) {
        return ReflectionUtils.newInstance(interfaze, (InvocationHandler)new LazyInstantiationHandler(clazz, args));
    }

    public static <T> T newLazyInstance(Class<T> interfaze, String clazz, Object ... args) {
        return ReflectionUtils.newInstance(interfaze, (InvocationHandler)new LazyInstantiationHandler(clazz, args));
    }

    private static <T> Constructor<T> findMatchingConstructor(boolean open, Class<T> clazz, Class<?>[] clazzes) {
        assert (clazz != null);
        try {
            Constructor<?>[] constructors;
            if (clazzes == null) {
                return open ? clazz.getDeclaredConstructor(new Class[0]) : clazz.getConstructor(new Class[0]);
            }
            Constructor<?>[] constructorArray = constructors = open ? clazz.getDeclaredConstructors() : clazz.getConstructors();
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                Class<?>[] expectedParameterTypes = constructor.getParameterTypes();
                if (expectedParameterTypes.length == clazzes.length) {
                    boolean stop = false;
                    int j = 0;
                    while (j < expectedParameterTypes.length && !stop) {
                        if (!expectedParameterTypes[j].isAssignableFrom(clazzes[j])) {
                            stop = true;
                        }
                        ++j;
                    }
                    if (!stop) {
                        return constructor;
                    }
                }
                ++n2;
            }
            throw new ReflectionFailure("Could not find a matching constructor for " + clazz.getName());
        }
        catch (NoSuchMethodException nsme) {
            throw new ReflectionFailure("Could not find a matching constructor for " + clazz.getName(), nsme);
        }
    }

    private static Method findMatchingMethod(boolean open, Class<?> clazz, String name, Class<?>[] clazzes) {
        assert (clazz != null);
        assert (name != null);
        try {
            Method[] methods;
            if (clazzes == null) {
                return clazz.getDeclaredMethod(name, new Class[0]);
            }
            Method[] methodArray = methods = open ? clazz.getDeclaredMethods() : clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] expectedParameterTypes;
                Method method = methodArray[n2];
                if (method.getName().equals(name) && (expectedParameterTypes = method.getParameterTypes()).length == clazzes.length) {
                    boolean stop = false;
                    int j = 0;
                    while (j < expectedParameterTypes.length && !stop) {
                        if (!expectedParameterTypes[j].isAssignableFrom(clazzes[j])) {
                            stop = true;
                        }
                        ++j;
                    }
                    if (!stop) {
                        return method;
                    }
                }
                ++n2;
            }
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Class<? extends Object>[] classesPrimitiveFromObjects(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Class[] clazzes = new Class[objects.length];
        int i = 0;
        while (i < objects.length) {
            Class argClass = Object.class;
            if (objects[i] != null) {
                argClass = objects[i].getClass();
                if (argClass == Integer.class) {
                    argClass = Integer.TYPE;
                } else if (argClass == Long.class) {
                    argClass = Long.TYPE;
                } else if (argClass == Short.class) {
                    argClass = Short.TYPE;
                } else if (argClass == Boolean.class) {
                    argClass = Boolean.TYPE;
                } else if (argClass == Byte.class) {
                    argClass = Byte.TYPE;
                } else if (argClass == Float.class) {
                    argClass = Float.TYPE;
                } else if (argClass == Double.class) {
                    argClass = Double.TYPE;
                } else if (argClass == Character.class) {
                    argClass = Character.TYPE;
                }
            }
            clazzes[i] = argClass;
            ++i;
        }
        return clazzes;
    }

    private static Class<? extends Object>[] classesFromObjects(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Class[] clazzes = new Class[objects.length];
        int i = 0;
        while (i < objects.length) {
            clazzes[i] = objects[i] == null ? Object.class : objects[i].getClass();
            ++i;
        }
        return clazzes;
    }

    private static Class<?> getClass(Object instance) {
        assert (instance != null);
        return instance instanceof Class ? (Class<?>)instance : instance.getClass();
    }

    private static Field getDeepField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        assert (clazz != null);
        assert (fieldName != null);
        Class<?> lookIn = clazz;
        while (lookIn != null) {
            try {
                return lookIn.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                lookIn = lookIn.getSuperclass();
            }
        }
        throw new NoSuchFieldException("Could not find field " + fieldName + " within class " + clazz + ".");
    }

    /*
     * Unable to fully structure code
     */
    private static <T> Class<T> loadClass(String className) {
        cnfe = null;
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            cnfe = e;
            bundles = Activator.getDefault().getContext().getBundles();
            foundClass = null;
            var7_5 = bundles;
            var6_6 = bundles.length;
            var5_7 = 0;
            ** while (var5_7 < var6_6)
        }
lbl-1000:
        // 1 sources

        {
            bundle = var7_5[var5_7];
            try {
                if (foundClass != null) {
                    throw new ReflectionFailure("Could not load class " + className + " because it exists in at least two bundles.");
                }
                cnfe = null;
                foundClass = bundle.loadClass(className);
                return bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
                ++var5_7;
            }
            continue;
        }
lbl23:
        // 1 sources

        if (foundClass == null) {
            throw new ReflectionFailure("Could not load class " + className + ".", cnfe);
        }
        return foundClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyInstantiationHandler
    implements InvocationHandler {
        private Object instance;
        private Class<?> clazz;
        private String clazzName;
        private Object[] params;

        public LazyInstantiationHandler(Class<?> clazz, Object[] args) {
            this.clazz = clazz;
            this.params = args;
        }

        public LazyInstantiationHandler(String clazz, Object[] args) {
            this.clazzName = clazz;
            this.params = args;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.instance == null) {
                this.instance = this.clazz != null ? ReflectionUtils.newInstance(this.clazz, this.params) : ReflectionUtils.newInstance(this.clazzName, this.params);
            }
            return ReflectionUtils.invoke(this.instance, method.getName(), args);
        }
    }
}

