/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import org.eclipse.riena.core.wire.Wire;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceAccessor<S> {
    private S service;
    private final BundleContext context;
    private final IBindHook<S> bindHook;
    private boolean initialized;

    public ServiceAccessor(BundleContext context) {
        this(context, null);
    }

    public ServiceAccessor(BundleContext context, IBindHook<S> bindHook) {
        this.context = context;
        this.bindHook = bindHook;
    }

    public synchronized S getService() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return this.service;
    }

    public void bind(S service) {
        this.service = service;
        if (this.bindHook != null) {
            this.bindHook.onBind(service);
        }
    }

    public void unbind(S service) {
        this.service = null;
        if (this.bindHook != null) {
            this.bindHook.onUnbind(service);
        }
    }

    private void initialize() {
        Wire.instance(this).andStart(this.context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBindHook<S> {
        public void onBind(S var1);

        public void onUnbind(S var1);
    }
}

