/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.IRienaStartupExtension;
import org.eclipse.riena.internal.core.exceptionmanager.ExceptionHandlerManagerAccessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class StartupsSafeRunnable
implements ISafeRunnable {
    private IRienaStartupExtension[] startups;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), StartupsSafeRunnable.class);

    public void handleException(Throwable exception) {
        IExceptionHandlerManager manager = ExceptionHandlerManagerAccessor.getExceptionHandlerManager();
        if (manager != null) {
            manager.handleException(exception, "Error activating bundels.", LOGGER);
            return;
        }
        LOGGER.log(1, "Error activating bundels.", exception);
    }

    public void run() throws Exception {
        IRienaStartupExtension startup;
        if (this.startups == null) {
            return;
        }
        IRienaStartupExtension[] iRienaStartupExtensionArray = this.startups;
        int n = this.startups.length;
        int n2 = 0;
        while (n2 < n) {
            String[] bundleNames;
            startup = iRienaStartupExtensionArray[n2];
            String[] stringArray = bundleNames = PropertiesUtils.asArray(startup.getRequiredBundles());
            int n3 = bundleNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String bundleName = stringArray[n4];
                if (!StringUtils.isEmpty(bundleName)) {
                    Bundle bundle = Platform.getBundle((String)bundleName);
                    if (bundle != null) {
                        if (bundle.getState() != 32) {
                            this.start(bundle);
                        } else {
                            LOGGER.log(3, "Startup required bundle: '" + bundleName + "' already started.");
                        }
                    } else {
                        LOGGER.log(2, "Startup required bundle: '" + bundleName + "' not found.");
                    }
                }
                ++n4;
            }
            ++n2;
        }
        iRienaStartupExtensionArray = this.startups;
        n = this.startups.length;
        n2 = 0;
        while (n2 < n) {
            startup = iRienaStartupExtensionArray[n2];
            Bundle bundle = startup.getContributingBundle();
            String runClassName = startup.getRunClassName();
            if (StringUtils.isGiven(runClassName)) {
                try {
                    startup.createRunner().run();
                    LOGGER.log(3, "Startup: '" + bundle.getSymbolicName() + "' with starter '" + runClassName + "' succesful.");
                }
                catch (Exception e) {
                    LOGGER.log(1, "Startup: '" + bundle.getSymbolicName() + "' with starter '" + runClassName + "' failed.", (Throwable)e);
                }
            }
            if (startup.isActivateSelf()) {
                if (bundle.getState() == 4) {
                    this.start(bundle);
                } else if (bundle.getState() == 8 && "lazy".equals(bundle.getHeaders().get("Bundle-ActivationPolicy"))) {
                    try {
                        bundle.start();
                        LOGGER.log(3, "Startup <<lazy>>: '" + bundle.getSymbolicName() + "' succesful.");
                    }
                    catch (BundleException be) {
                        LOGGER.log(2, "Startup <<lazy>>: '" + bundle.getSymbolicName() + "' failed but may succeed (bundle state is in transition):\n\t\t" + be.getMessage() + (be.getCause() != null ? " cause: " + be.getCause() : ""));
                    }
                    catch (RuntimeException rte) {
                        LOGGER.log(1, "Startup <<lazy>>:: '" + bundle.getSymbolicName() + "' failed with exception.", (Throwable)rte);
                    }
                } else if (bundle.getState() == 2) {
                    LOGGER.log(1, "Startup: '" + bundle.getSymbolicName() + "' failed. Startup extension is set but is only in state INSTALLED (not RESOLVED).");
                } else if (bundle.getState() == 32) {
                    LOGGER.log(4, "Startup: '" + bundle.getSymbolicName() + "' is already ACTIVE.");
                }
            }
            ++n2;
        }
    }

    private void start(Bundle bundle) throws BundleException {
        if (bundle == null) {
            return;
        }
        try {
            bundle.start();
            LOGGER.log(3, "Startup: '" + bundle.getSymbolicName() + "' succesful.");
        }
        catch (RuntimeException rte) {
            LOGGER.log(1, "Startup: '" + bundle.getSymbolicName() + "' failed with exception.", (Throwable)rte);
        }
    }

    @InjectExtension(id="org.eclipse.riena.core.startups")
    public void update(IRienaStartupExtension[] startups) {
        this.startups = startups;
    }
}

