/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.monitor.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.core.wire.WirePuller;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.internal.monitor.client.Activator;
import org.eclipse.riena.internal.monitor.client.AggregatorWiring;
import org.eclipse.riena.internal.monitor.client.IClientInfoProviderExtension;
import org.eclipse.riena.internal.monitor.client.ICollectorExtension;
import org.eclipse.riena.internal.monitor.client.ISenderExtension;
import org.eclipse.riena.internal.monitor.client.IStoreExtension;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.IAggregator;
import org.eclipse.riena.monitor.client.IClientInfoProvider;
import org.eclipse.riena.monitor.client.ICollector;
import org.eclipse.riena.monitor.client.ISender;
import org.eclipse.riena.monitor.client.IStore;
import org.eclipse.riena.monitor.common.Collectible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WireWith(value=AggregatorWiring.class)
public class Aggregator
implements IAggregator {
    private IClientInfoProvider clientInfoProvider;
    private IStore store;
    private WirePuller storeWiring;
    private ISender sender;
    private WirePuller senderWiring;
    private ICollector[] collectors;
    private List<WirePuller> collectorWirings;
    private boolean workerStop;
    private boolean started;
    private final BlockingQueue<Runnable> workQueue;
    private final Map<String, Category> nameCategories = new HashMap<String, Category>();
    private final Map<ICollector, Category> collectorCategories = new HashMap<ICollector, Category>();
    private final CountDownLatch workSignal = new CountDownLatch(1);
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), Aggregator.class);

    public Aggregator() {
        this.workQueue = new LinkedBlockingQueue<Runnable>();
        this.startWorker();
    }

    private void startWorker() {
        new Thread((Runnable)new Worker(), "Client Monitoring Aggregator Worker").start();
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        if (this.collectors.length == 0) {
            LOGGER.log(2, "Client monitoring not started. No collectors defined.");
            return;
        }
        if (this.sender == null) {
            LOGGER.log(2, "Client monitoring not started. No sender defined.");
            return;
        }
        if (this.store == null) {
            LOGGER.log(2, "Client monitoring not started. No store defined.");
            return;
        }
        this.store.open(this.nameCategories);
        this.sender.start(this.store, this.nameCategories.values());
        for (ICollector collector : Iter.able((Object[])this.collectors)) {
            collector.start(this, this.collectorCategories.get(collector), this.clientInfoProvider);
        }
        this.workerStop = false;
        this.started = true;
        this.workSignal.countDown();
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.stopWorker();
        this.stopCollectors();
        this.stopSender();
        this.stopStore();
        this.started = false;
    }

    public synchronized void update(IClientInfoProviderExtension clientInfoProviderExtension) {
        this.stopSender();
        if (clientInfoProviderExtension == null) {
            return;
        }
        this.clientInfoProvider = clientInfoProviderExtension.createClientInfoProvider();
    }

    public synchronized void update(ICollectorExtension[] collectorExtensions) {
        this.stopCollectors();
        this.nameCategories.clear();
        this.collectorCategories.clear();
        ArrayList<ICollector> list = new ArrayList<ICollector>(collectorExtensions.length);
        this.collectorWirings = new ArrayList<WirePuller>(collectorExtensions.length);
        ICollectorExtension[] iCollectorExtensionArray = collectorExtensions;
        int n = collectorExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ICollectorExtension extension = iCollectorExtensionArray[n2];
            Assert.isLegal((!this.nameCategories.containsKey(extension.getCategory()) ? 1 : 0) != 0, (String)("Category " + extension.getCategory() + " is defined twice. Categories must be unique."));
            Category category = new Category(extension.getCategory(), extension.getMaxItems());
            this.nameCategories.put(extension.getCategory(), category);
            ICollector collector = extension.createCollector();
            this.collectorCategories.put(collector, category);
            this.collectorWirings.add(Wire.instance((Object)collector).andStart(Activator.getDefault().getContext()));
            list.add(collector);
            ++n2;
        }
        this.collectors = list.toArray(new ICollector[list.size()]);
    }

    private void stopWorker() {
        this.workerStop = true;
    }

    private void stopCollectors() {
        for (ICollector collector : Iter.able((Object[])this.collectors)) {
            collector.stop();
        }
        for (WirePuller wirings : Iter.able(this.collectorWirings)) {
            wirings.stop();
        }
    }

    public void update(ISenderExtension senderExtension) {
        this.stopSender();
        if (senderExtension == null) {
            return;
        }
        this.sender = senderExtension.createSender();
        this.senderWiring = Wire.instance((Object)this.sender).andStart(Activator.getDefault().getContext());
    }

    private void stopSender() {
        if (this.sender != null) {
            this.sender.stop();
            this.sender = null;
        }
        if (this.senderWiring != null) {
            this.senderWiring.stop();
            this.senderWiring = null;
        }
    }

    public synchronized void update(IStoreExtension storeExtension) {
        this.stopStore();
        if (storeExtension == null) {
            return;
        }
        this.store = storeExtension.createStore();
        this.storeWiring = Wire.instance((Object)this.store).andStart(Activator.getDefault().getContext());
    }

    private void stopStore() {
        if (this.store != null) {
            this.store.flush();
            this.store = null;
        }
        if (this.storeWiring != null) {
            this.storeWiring.stop();
        }
    }

    @Override
    public synchronized void collect(Collectible<?> collectible) {
        if (!this.started) {
            return;
        }
        boolean elementAdded = this.workQueue.offer(new CollectTask(this.store, collectible));
        Assert.isTrue((boolean)elementAdded);
    }

    @Override
    public synchronized void triggerTransfer(String category) {
        boolean elementAdded = this.workQueue.offer(new TriggerTransferTask(this.store, this.sender, category));
        Assert.isTrue((boolean)elementAdded);
    }

    static /* synthetic */ CountDownLatch access$0(Aggregator aggregator) {
        return aggregator.workSignal;
    }

    static /* synthetic */ boolean access$1(Aggregator aggregator) {
        return aggregator.workerStop;
    }

    static /* synthetic */ BlockingQueue access$2(Aggregator aggregator) {
        return aggregator.workQueue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectTask
    implements Runnable {
        private final IStore store;
        private final Collectible<?> collectible;

        public CollectTask(IStore store, Collectible<?> collectible) {
            Assert.isLegal((store != null ? 1 : 0) != 0, (String)"store must be not null");
            this.store = store;
            this.collectible = collectible;
        }

        @Override
        public void run() {
            this.store.collect(this.collectible);
        }
    }

    private static final class TriggerTransferTask
    implements Runnable {
        private final IStore store;
        private final ISender sender;
        private final String category;

        public TriggerTransferTask(IStore store, ISender sender, String category) {
            this.store = store;
            this.sender = sender;
            this.category = category;
        }

        public void run() {
            this.store.prepareTransferables(this.category);
            this.sender.triggerTransfer(this.category);
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            try {
                Aggregator.access$0(Aggregator.this).await();
                if (true) ** GOTO lbl15
            }
            catch (InterruptedException v0) {
                Thread.currentThread().interrupt();
                return;
            }
            do {
                try {
                    runnable = (Runnable)Aggregator.access$2(Aggregator.this).take();
                    runnable.run();
                }
                catch (InterruptedException v1) {
                    Thread.currentThread().interrupt();
                    break;
                }
lbl15:
                // 2 sources

            } while (!Aggregator.access$1(Aggregator.this));
        }
    }
}

