/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ScrollingSupport {
    private static final int SCROLLING_STEP = 20;
    private IModuleNavigationComponentProvider navigationComponentProvider;
    private ScrollControlComposite scrollControlComposite;
    private int scrolledCompositeOffset = 0;
    private int cachedScrolledCompositeHeight = 0;
    private IModuleGroupNode cachedModuleGroupNode;

    public ScrollingSupport(Composite parent, int flags, IModuleNavigationComponentProvider navigationComponentProvider) {
        this.navigationComponentProvider = navigationComponentProvider;
        this.scrollControlComposite = new ScrollControlComposite(parent, flags);
        this.setBodyCompositeOffset(0);
        this.initMouseWheelObserver();
    }

    private void initMouseWheelObserver() {
        Display display = this.getNavigationComponent().getDisplay();
        display.addFilter(37, (Listener)new MouseWheelAdapter());
    }

    public Composite getScrollComposite() {
        return this.scrollControlComposite;
    }

    private void scrollUp() {
        int offset = Math.min(this.scrolledCompositeOffset + 20, 0);
        this.setBodyCompositeOffset(offset);
    }

    private void scrollDown() {
        int offset = Math.max(this.getNavigationComponentHeight() - this.getScrolledComponentHeight(), this.scrolledCompositeOffset - 20);
        this.setBodyCompositeOffset(offset);
    }

    public void autoScrolling() {
        this.scrollControlComposite.setVisible(this.scrollingRequired());
        this.checkScrollToActiveModuleGroup();
    }

    public boolean scrollingRequired() {
        return this.getScrolledComponentHeight() > this.getNavigationComponentHeight();
    }

    private void checkScrollToActiveModuleGroup() {
        if (!this.scrollingRequired()) {
            this.resetScrolling();
            return;
        }
        if (!this.isActiveModuleGroupViewVisible()) {
            this.scrollToActiveModuleGroup();
        } else {
            this.ensureFilledToBottom();
        }
    }

    private void ensureFilledToBottom() {
        int bodyBottomY = this.scrolledCompositeOffset + this.getScrolledComponentHeight();
        if (bodyBottomY < this.getNavigationComponentHeight()) {
            this.setBodyCompositeOffset(this.scrolledCompositeOffset + (this.getNavigationComponentHeight() - bodyBottomY));
        }
    }

    public void scroll() {
        IModuleGroupNode activeModuleGroupNode = this.navigationComponentProvider.getActiveModuleGroupNode();
        if (this.scrollingRequired()) {
            if (this.activeModuleGroupChanged(activeModuleGroupNode)) {
                this.autoScrolling();
                this.cachedModuleGroupNode = activeModuleGroupNode;
            } else {
                if (this.getScrolledComponentHeight() != this.cachedScrolledCompositeHeight) {
                    this.scrollControlComposite.setVisible(true);
                }
                this.ensureFilledToBottom();
            }
        } else {
            if (this.activeModuleGroupChanged(activeModuleGroupNode)) {
                this.cachedModuleGroupNode = activeModuleGroupNode;
            }
            this.resetScrolling();
        }
        this.cachedScrolledCompositeHeight = this.getScrolledComponentHeight();
    }

    private boolean activeModuleGroupChanged(IModuleGroupNode activeModuleGroupNode) {
        return activeModuleGroupNode != null && this.cachedModuleGroupNode != activeModuleGroupNode;
    }

    public void resetScrolling() {
        this.setBodyCompositeOffset(0);
        this.scrollControlComposite.setVisible(false);
    }

    private void scrollToActiveModuleGroup() {
        int offset;
        this.calculateActiveModuleGrouViewBounds();
        Point activeModuleGroupPosition = this.getActiveModuleGroupPosition();
        if (this.calculateActiveModuleGrouViewBounds().height < this.getNavigationComponentHeight()) {
            boolean scrollDownRequired;
            boolean bl = scrollDownRequired = activeModuleGroupPosition.y < 0;
            offset = scrollDownRequired ? Math.max(0, this.scrolledCompositeOffset - activeModuleGroupPosition.y) : this.scrolledCompositeOffset - (activeModuleGroupPosition.y + this.calculateActiveModuleGrouViewBounds().height - this.getNavigationComponentHeight());
        } else {
            offset = -this.calculateActiveModuleGrouViewBounds().y;
        }
        this.setBodyCompositeOffset(offset);
    }

    private Composite getNavigationComponent() {
        return this.navigationComponentProvider.getNavigationComponent();
    }

    private Composite getScrolledComponent() {
        return this.navigationComponentProvider.getScrolledComponent();
    }

    private int getNavigationComponentHeight() {
        return this.getNavigationComponent().getBounds().height;
    }

    private int getScrolledComponentHeight() {
        return this.getScrolledComponent().getBounds().height;
    }

    private Point getModuleGroupPosition(Rectangle bounds) {
        Point position = new Point(bounds.x, bounds.y);
        position = this.getNavigationComponent().toControl(this.getScrolledComponent().toDisplay(position));
        return position;
    }

    private Rectangle calculateActiveModuleGrouViewBounds() {
        IModuleGroupNode activeModuleGroup = this.navigationComponentProvider.getActiveModuleGroupNode();
        if (activeModuleGroup != null) {
            return this.calculateModuleGroupViewBounds(activeModuleGroup);
        }
        return null;
    }

    private Rectangle calculateModuleGroupViewBounds(IModuleGroupNode moduleGroupNode) {
        ModuleGroupView activeModuleGroupView = this.navigationComponentProvider.getModuleGroupViewForNode(moduleGroupNode);
        return activeModuleGroupView.getBounds();
    }

    private boolean isActiveModuleGroupViewVisible() {
        Point activeModuleGroupPosition = this.getActiveModuleGroupPosition();
        return this.isModuleGroupViewVisible(activeModuleGroupPosition, this.calculateActiveModuleGrouViewBounds());
    }

    private boolean isModuleGroupViewVisible(Point moduleGroupViewPosition, Rectangle moduleGroupViewBounds) {
        return moduleGroupViewPosition.y >= 0 && moduleGroupViewPosition.y + moduleGroupViewBounds.height <= this.getNavigationComponentHeight();
    }

    private Point getActiveModuleGroupPosition() {
        Rectangle activeMgVerticalBounds = this.calculateActiveModuleGrouViewBounds();
        return this.getModuleGroupPosition(activeMgVerticalBounds);
    }

    private void setBodyCompositeOffset(int yScrolledOffset) {
        this.scrolledCompositeOffset = yScrolledOffset;
        this.updateUI();
    }

    private void updateUI() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, this.scrolledCompositeOffset);
        this.getScrolledComponent().setLayoutData((Object)formData);
        this.updateLayout();
    }

    private void updateLayout() {
        this.getScrolledComponent().getParent().layout();
    }

    private class MouseWheelAdapter
    implements Listener {
        private int lastEventTime = 0;

        private MouseWheelAdapter() {
        }

        public void handleEvent(Event event) {
            if (ScrollingSupport.this.scrollingRequired() && event.time > this.lastEventTime) {
                this.lastEventTime = event.time;
                Rectangle navigationComponentBounds = ScrollingSupport.this.getNavigationComponent().getBounds();
                Point navigationPtAtDisplay = ScrollingSupport.this.getNavigationComponent().toDisplay(0, 0);
                navigationComponentBounds.x = navigationPtAtDisplay.x;
                navigationComponentBounds.y = navigationPtAtDisplay.y;
                if (event.widget instanceof Control) {
                    Control widget = (Control)event.widget;
                    Point evtPt = widget.toDisplay(event.getBounds().x, event.getBounds().y);
                    if (navigationComponentBounds.contains(evtPt.x, evtPt.y)) {
                        if (event.count > 0) {
                            ScrollingSupport.this.scrollUp();
                            return;
                        }
                        ScrollingSupport.this.scrollDown();
                    }
                }
            }
        }
    }

    private class ScrollControlComposite
    extends Composite {
        private Button upButton;
        private Button downButton;

        public ScrollControlComposite(Composite parent, int style) {
            super(parent, style);
            ScrollingSupport.this.getNavigationComponent().addControlListener((ControlListener)new NavigationResizeListener());
            this.setBackground(LnfManager.getLnf().getColor("Navigation.background"));
            this.initControlButtons();
        }

        private void initControlButtons() {
            this.setLayout((Layout)new FormLayout());
            ScrollDelegation delegationAdaper = new ScrollDelegation();
            this.upButton = new Button((Composite)this, 0);
            this.upButton.setImage(LnfManager.getLnf().getImage("navigation.scrollup"));
            this.upButton.addSelectionListener((SelectionListener)delegationAdaper);
            this.layoutUpButton();
            this.downButton = new Button((Composite)this, 0);
            this.downButton.setImage(LnfManager.getLnf().getImage("navigation.scrollDown"));
            this.downButton.addSelectionListener((SelectionListener)delegationAdaper);
            this.layoutDownButton();
        }

        private void layoutDownButton() {
            this.downButton.setText("");
            FormData fd = new FormData();
            fd.left = new FormAttachment((Control)this.upButton, 2);
            fd.height = 12;
            fd.width = 80;
            this.downButton.setLayoutData((Object)fd);
        }

        private void layoutUpButton() {
            this.upButton.setText("");
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 4);
            fd.height = 12;
            fd.width = 80;
            this.upButton.setLayoutData((Object)fd);
        }

        private class NavigationResizeListener
        extends ControlAdapter {
            private NavigationResizeListener() {
            }

            public void controlResized(ControlEvent e) {
                ScrollControlComposite.this.setVisible(ScrollingSupport.this.scrollingRequired());
            }
        }

        private class ScrollDelegation
        extends SelectionAdapter {
            private ScrollDelegation() {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ScrollControlComposite.this.upButton) {
                    ScrollingSupport.this.scrollUp();
                    return;
                }
                ScrollingSupport.this.scrollDown();
            }
        }
    }
}

