/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.filter.impl;

import java.util.ArrayList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.internal.ui.filter.Activator;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.filter.IUIFilterContainer;
import org.eclipse.riena.ui.filter.IUIFilterProvider;
import org.eclipse.riena.ui.filter.IUIFilterRule;
import org.eclipse.riena.ui.filter.IUIFilterRuleMarker;
import org.eclipse.riena.ui.filter.IUIFilterRuleValidator;
import org.eclipse.riena.ui.filter.IUIFilterRuleValidatorRidget;
import org.eclipse.riena.ui.filter.extension.IRuleValidatorRidget;
import org.eclipse.riena.ui.filter.extension.IUIFilterExtension;
import org.eclipse.riena.ui.filter.impl.RulesProvider;
import org.eclipse.riena.ui.filter.impl.UIFilter;
import org.eclipse.riena.ui.filter.impl.UIFilterContainer;
import org.eclipse.riena.ui.filter.impl.UIFilterProviderWiring;

@WireWith(value=UIFilterProviderWiring.class)
public class UIFilterProvider
implements IUIFilterProvider {
    private IUIFilterExtension[] data;

    protected IUIFilterExtension getUIFilterDefinition(String filterId) {
        if (this.getData().length == 0 || filterId == null) {
            return null;
        }
        IUIFilterExtension[] iUIFilterExtensionArray = this.getData();
        int n = iUIFilterExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUIFilterExtension extension = iUIFilterExtensionArray[n2];
            if (extension.getFilterId() != null && extension.getFilterId().equals(filterId)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    public IUIFilterContainer provideFilter(String filterID) {
        String id;
        IUIFilterRuleMarker rule;
        String markerType;
        Object ruleExtension;
        IUIFilterExtension filterExtension = this.getUIFilterDefinition(filterID);
        ArrayList<IUIFilterRule> rules = new ArrayList<IUIFilterRule>(1);
        RulesProvider rulesProvider = this.newRulesProvider();
        Object[] objectArray = filterExtension.getRuleMarkerRidgets();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ruleExtension = objectArray[n2];
            markerType = ruleExtension.getMarker();
            rule = rulesProvider.getRuleMarkerRidget(markerType);
            if (rule != null) {
                id = ruleExtension.getRidgetId();
                rule.setId(id);
                rules.add(rule);
            }
            ++n2;
        }
        objectArray = filterExtension.getRuleMarkerMenuItems();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            ruleExtension = objectArray[n2];
            markerType = ruleExtension.getMarker();
            rule = rulesProvider.getRuleMarkerMenuItem(markerType);
            if (rule != null) {
                id = ruleExtension.getItemId();
                rule.setId(id);
                rules.add(rule);
            }
            ++n2;
        }
        objectArray = filterExtension.getRuleMarkerNavigations();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            ruleExtension = objectArray[n2];
            markerType = ruleExtension.getMarker();
            rule = rulesProvider.getRuleMarkerNavigation(markerType);
            if (rule != null) {
                id = ruleExtension.getNodeId();
                rule.setNode(id);
                rules.add(rule);
            }
            ++n2;
        }
        objectArray = filterExtension.getRuleValidatorRidgets();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            ruleExtension = objectArray[n2];
            IUIFilterRuleValidator rule2 = this.createRuleValidatorRidget((IRuleValidatorRidget)ruleExtension);
            if (rule2 != null) {
                rules.add(rule2);
            }
            ++n2;
        }
        UIFilter filterResult = new UIFilter(filterID, rules);
        return new UIFilterContainer(filterResult, filterExtension.getNodeIds());
    }

    private IUIFilterRuleValidator createRuleValidatorRidget(IRuleValidatorRidget ruleExtension) {
        RulesProvider rulesProvider = this.newRulesProvider();
        IUIFilterRuleValidatorRidget rule = rulesProvider.getRuleValidatorRidget();
        if (rule != null) {
            rule.setId(ruleExtension.getRidgetId());
            String timeString = ruleExtension.getValidationTime();
            ValidationTime time = ValidationTime.ON_UPDATE_TO_MODEL;
            if (timeString != null && timeString.equals("onUIControlEdit")) {
                time = ValidationTime.ON_UI_CONTROL_EDIT;
            }
            rule.setValidationTime(time);
            IValidator validator = ruleExtension.getValidator();
            rule.setValidator(validator);
        }
        return rule;
    }

    public void update(IUIFilterExtension[] data) {
        this.data = data;
    }

    private IUIFilterExtension[] getData() {
        return this.data;
    }

    private RulesProvider newRulesProvider() {
        RulesProvider rulesProvider = new RulesProvider();
        Wire.instance((Object)rulesProvider).andStart(Activator.getDefault().getContext());
        return rulesProvider;
    }
}

