/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleChoiceRidget
extends AbstractSWTRidget
implements ISingleChoiceRidget {
    private static final LnFUpdater LNF_UPDATER = new LnFUpdater();
    private final WritableList optionsObservable = new WritableList();
    private final WritableValue selectionObservable = new WritableValue();
    private Binding optionsBinding;
    private Binding selectionBinding;
    private String[] optionLabels;

    public SingleChoiceRidget() {
        this.selectionObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                SingleChoiceRidget.this.disableMandatoryMarkers(SingleChoiceRidget.this.hasInput());
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SingleChoiceRidget.this.updateSelection((Composite)SingleChoiceRidget.this.getUIControl());
            }
        });
    }

    @Override
    protected void bindUIControl() {
        if (this.optionsBinding != null) {
            this.createChildren((Composite)this.getUIControl());
        }
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, ChoiceComposite.class);
        if (uiControl != null) {
            ChoiceComposite composite = (ChoiceComposite)uiControl;
            Assert.isTrue((!composite.isMultipleSelection() ? 1 : 0) != 0, (String)"expected single selection ChoiceComposite");
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        ChoiceComposite control = this.getUIControl();
        this.disposeChildren((Composite)control);
    }

    public ChoiceComposite getUIControl() {
        return (ChoiceComposite)super.getUIControl();
    }

    public void bindToModel(IObservableList optionValues, IObservableValue selectionValue) {
        Assert.isNotNull((Object)optionValues, (String)"optionValues");
        Assert.isNotNull((Object)selectionValue, (String)"selectionValue");
        this.bindToModel(optionValues, null, selectionValue);
    }

    public void bindToModel(Object listHolder, String listPropertyName, Object selectionHolder, String selectionPropertyName) {
        Assert.isNotNull((Object)listHolder, (String)"listHolder");
        Assert.isNotNull((Object)listPropertyName, (String)"listPropertyName");
        Assert.isNotNull((Object)selectionHolder, (String)"selectionHolder");
        Assert.isNotNull((Object)selectionPropertyName, (String)"selectionPropertyName");
        IObservableList optionValues = PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        IObservableValue selectionValue = PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel(optionValues, null, selectionValue);
    }

    public void bindToModel(List<? extends Object> optionValues, List<String> optionLabels, Object selectionHolder, String selectionPropertyName) {
        Assert.isNotNull(optionValues, (String)"optionValues");
        Assert.isNotNull((Object)selectionHolder, (String)"selectionHolder");
        Assert.isNotNull((Object)selectionPropertyName, (String)"selectionPropertyName");
        WritableList list = new WritableList(optionValues, null);
        IObservableValue selection = PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel((IObservableList)list, optionLabels, selection);
    }

    public void updateFromModel() {
        this.assertIsBoundToModel();
        super.updateFromModel();
        this.optionsBinding.updateModelToTarget();
        Object oldSelection = this.selectionObservable.getValue();
        this.selectionBinding.updateModelToTarget();
        ChoiceComposite control = this.getUIControl();
        this.disposeChildren((Composite)control);
        this.createChildren((Composite)control);
        this.firePropertyChange("selection", oldSelection, this.selectionObservable.getValue());
    }

    public Object getSelection() {
        return this.selectionObservable.getValue();
    }

    public void setSelection(Object candidate) {
        this.assertIsBoundToModel();
        if (candidate != null && !this.optionsObservable.contains(candidate)) {
            throw new BindingException("candidate not in option list: " + candidate);
        }
        Object oldSelection = this.selectionObservable.getValue();
        this.selectionObservable.setValue(candidate);
        this.updateSelection((Composite)this.getUIControl());
        this.firePropertyChange("selection", oldSelection, candidate);
    }

    public IObservableList getObservableList() {
        return this.optionsObservable;
    }

    @Override
    public final boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    private void assertIsBoundToModel() {
        if (this.optionsBinding == null || this.selectionBinding == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindToModel(IObservableList optionValues, List<String> optionLabels, IObservableValue selectionValue) {
        if (optionLabels != null) {
            String msg = "Mismatch between number of optionValues and optionLabels";
            Assert.isLegal((optionValues.size() == optionLabels.size() ? 1 : 0) != 0, (String)msg);
        }
        this.unbindUIControl();
        if (this.optionsBinding != null) {
            this.optionsBinding.dispose();
            this.optionsBinding = null;
            this.optionsObservable.clear();
        }
        if (this.selectionBinding != null) {
            this.selectionBinding.dispose();
            this.selectionBinding = null;
            this.selectionObservable.setValue(null);
        }
        DataBindingContext dbc = new DataBindingContext();
        this.optionsBinding = dbc.bindList((IObservableList)this.optionsObservable, optionValues, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.selectionBinding = dbc.bindValue((IObservableValue)this.selectionObservable, selectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.optionLabels = optionLabels != null ? optionLabels.toArray(new String[optionLabels.size()]) : null;
        this.bindUIControl();
    }

    private void createChildren(Composite control) {
        if (control != null && !control.isDisposed()) {
            Object[] values = this.optionsObservable.toArray();
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                String caption = this.optionLabels != null ? this.optionLabels[i] : String.valueOf(value);
                Button button = new Button(control, 16);
                button.setText(caption);
                button.setForeground(control.getForeground());
                button.setBackground(control.getBackground());
                button.setData(value);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.widget;
                        Object data = button.getData();
                        if (button.getSelection()) {
                            if (SingleChoiceRidget.this.isOutputOnly()) {
                                SingleChoiceRidget.this.updateSelection((Composite)SingleChoiceRidget.this.getUIControl());
                            } else {
                                SingleChoiceRidget.this.setSelection(data);
                                SingleChoiceRidget.this.fireFocusIn((Control)button.getParent());
                            }
                        }
                    }
                });
                ++i;
            }
            this.updateSelection(control);
            LNF_UPDATER.updateUIControlsAfterBind(control);
            control.layout();
        }
    }

    private void disposeChildren(Composite control) {
        if (control != null && !control.isDisposed()) {
            Control[] controlArray = control.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    private void fireFocusIn(Control control) {
        Event event = new Event();
        event.type = 15;
        event.widget = control;
        control.notifyListeners(15, event);
    }

    private boolean hasInput() {
        return this.selectionObservable.getValue() != null;
    }

    private void updateSelection(Composite control) {
        boolean canSelect;
        boolean bl = canSelect = this.isEnabled() || !MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT;
        if (control != null && !control.isDisposed()) {
            Object value = this.selectionObservable.getValue();
            Control[] controlArray = control.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Button button = (Button)child;
                boolean isSelected = canSelect && value != null && value.equals(child.getData());
                button.setSelection(isSelected);
                ++n2;
            }
        }
    }
}

