/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareValidator;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidgetLabelProvider;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSelectableRidget;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeRidget
extends AbstractSelectableRidget
implements ITreeRidget {
    private static final Listener ERASE_LISTENER = new EraseAndPaintListener();
    private final SelectionListener selectionTypeEnforcer = new SelectionTypeEnforcer();
    private final DoubleClickForwarder doubleClickForwarder = new DoubleClickForwarder();
    private final Queue<ExpansionCommand> expansionStack = new LinkedList<ExpansionCommand>();
    private ListenerList<IActionListener> doubleClickListeners;
    private DataBindingContext dbc;
    private Binding viewerMSB;
    private TreeViewer viewer;
    private TreeItem[] savedSelection;
    private Object[] model;
    private Object[] treeRoots;
    private Class<? extends Object> treeElementClass;
    private String childrenAccessor;
    private String parentAccessor;
    private String[] valueAccessors;
    private String[] columnHeaders;
    private String enablementAccessor;
    private String visibilityAccessor;
    private String imageAccessor;
    private boolean showRoots = true;

    public TreeRidget() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TreeRidget.this.applyEraseListener();
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TreeRidget.this.saveSelection();
                if (TreeRidget.this.isOutputOnly()) {
                    TreeRidget.this.disposeMultipleSelectionBinding();
                } else {
                    TreeRidget.this.createMultipleSelectionBinding();
                }
            }
        });
    }

    @Override
    protected void bindUIControl() {
        Tree control = this.getUIControl();
        if (control != null && this.treeRoots != null) {
            this.checkColumns(control);
            this.bindToViewer(control);
            this.bindToSelection();
            control.addSelectionListener(this.selectionTypeEnforcer);
            control.addMouseListener((MouseListener)this.doubleClickForwarder);
            this.updateExpansionState();
            this.applyEraseListener();
            this.applyTableColumnHeaders(control);
        }
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Tree.class);
    }

    @Override
    protected void unbindUIControl() {
        Tree control;
        super.unbindUIControl();
        if (this.viewer != null) {
            Object[] elements = this.viewer.getExpandedElements();
            ExpansionCommand cmd = new ExpansionCommand(ExpansionState.RESTORE, elements);
            this.expansionStack.add(cmd);
        }
        if (this.dbc != null) {
            this.disposeMultipleSelectionBinding();
            this.dbc.dispose();
            this.dbc = null;
        }
        if ((control = this.getUIControl()) != null) {
            control.removeSelectionListener(this.selectionTypeEnforcer);
            control.removeMouseListener((MouseListener)this.doubleClickForwarder);
            control.removeListener(40, ERASE_LISTENER);
            control.removeListener(42, ERASE_LISTENER);
        }
        if (this.viewer != null) {
            this.viewer.setInput(null);
        }
        this.viewer = null;
    }

    @Override
    protected final List<?> getRowObservables() {
        ArrayList result = null;
        if (this.viewer != null) {
            ObservableListTreeContentProvider cp = (ObservableListTreeContentProvider)this.viewer.getContentProvider();
            result = new ArrayList(cp.getKnownElements());
        }
        return result;
    }

    protected void bindToModel(Object[] treeRoots, Class<? extends Object> treeElementClass, String childrenAccessor, String parentAccessor, String[] valueAccessors, String[] columnHeaders, String enablementAccessor, String visibilityAccessor, String imageAccessor) {
        Assert.isNotNull((Object)treeRoots);
        Assert.isLegal((treeRoots.length > 0 ? 1 : 0) != 0, (String)"treeRoots must have at least one entry");
        Assert.isNotNull(treeElementClass);
        Assert.isNotNull((Object)childrenAccessor);
        Assert.isNotNull((Object)parentAccessor);
        Assert.isNotNull((Object)valueAccessors);
        Assert.isLegal((valueAccessors.length > 0 ? 1 : 0) != 0, (String)"valueAccessors must have at least one entry");
        if (columnHeaders != null) {
            String msg = "Mismatch between number of valueAccessors and columnHeaders";
            Assert.isLegal((valueAccessors.length == columnHeaders.length ? 1 : 0) != 0, (String)msg);
        }
        this.unbindUIControl();
        this.model = treeRoots;
        this.treeRoots = new Object[this.model.length];
        System.arraycopy(this.model, 0, this.treeRoots, 0, this.treeRoots.length);
        this.treeElementClass = treeElementClass;
        this.childrenAccessor = childrenAccessor;
        this.parentAccessor = parentAccessor;
        this.valueAccessors = new String[valueAccessors.length];
        System.arraycopy(valueAccessors, 0, this.valueAccessors, 0, this.valueAccessors.length);
        if (columnHeaders != null) {
            this.columnHeaders = new String[columnHeaders.length];
            System.arraycopy(columnHeaders, 0, this.columnHeaders, 0, this.columnHeaders.length);
        } else {
            this.columnHeaders = null;
        }
        this.enablementAccessor = enablementAccessor;
        this.visibilityAccessor = visibilityAccessor;
        this.imageAccessor = imageAccessor;
        this.expansionStack.clear();
        if (treeRoots.length == 1) {
            ExpansionCommand cmd = new ExpansionCommand(ExpansionState.EXPAND, treeRoots[0]);
            this.expansionStack.add(cmd);
        }
        this.bindUIControl();
    }

    protected final TreeViewer getViewer() {
        return this.viewer;
    }

    protected IColumnFormatter[] getColumnFormatters(int numColumns) {
        return new IColumnFormatter[numColumns];
    }

    public Tree getUIControl() {
        return (Tree)super.getUIControl();
    }

    public void addDoubleClickListener(IActionListener listener) {
        Assert.isNotNull((Object)listener, (String)"listener is null");
        if (this.doubleClickListeners == null) {
            this.doubleClickListeners = new ListenerList(IActionListener.class);
        }
        this.doubleClickListeners.add((Object)listener);
    }

    public void bindToModel(Object[] treeRoots, Class<? extends Object> treeElementClass, String childrenAccessor, String parentAccessor, String valueAccessor) {
        Assert.isNotNull((Object)valueAccessor);
        String[] myValueAccessors = new String[]{valueAccessor};
        String[] noColumnHeaders = null;
        String noEnablementAccessor = null;
        String noVisibilityAccessor = null;
        String noImageAccessor = null;
        this.bindToModel(treeRoots, treeElementClass, childrenAccessor, parentAccessor, myValueAccessors, noColumnHeaders, noEnablementAccessor, noVisibilityAccessor, noImageAccessor);
    }

    public void bindToModel(Object[] treeRoots, Class<? extends Object> treeElementClass, String childrenAccessor, String parentAccessor, String valueAccessor, String enablementAccessor, String visibilityAccessor) {
        Assert.isNotNull((Object)valueAccessor);
        String[] myValueAccessors = new String[]{valueAccessor};
        String[] noColumnHeaders = null;
        String noImageAccessor = null;
        this.bindToModel(treeRoots, treeElementClass, childrenAccessor, parentAccessor, myValueAccessors, noColumnHeaders, enablementAccessor, visibilityAccessor, noImageAccessor);
    }

    public void bindToModel(Object[] treeRoots, Class<? extends Object> treeElementClass, String childrenAccessor, String parentAccessor, String valueAccessor, String enablementAccessor, String visibilityAccessor, String imageAccessor) {
        Assert.isNotNull((Object)valueAccessor);
        String[] myValueAccessors = new String[]{valueAccessor};
        String[] noColumnHeaders = null;
        this.bindToModel(treeRoots, treeElementClass, childrenAccessor, parentAccessor, myValueAccessors, noColumnHeaders, enablementAccessor, visibilityAccessor, imageAccessor);
    }

    public void collapse(Object element) {
        ExpansionCommand cmd = new ExpansionCommand(ExpansionState.COLLAPSE, element);
        this.expansionStack.add(cmd);
        this.updateExpansionState();
    }

    public void collapseAll() {
        ExpansionCommand cmd = new ExpansionCommand(ExpansionState.FULLY_COLLAPSE, null);
        this.expansionStack.add(cmd);
        this.updateExpansionState();
    }

    public void expand(Object element) {
        ExpansionCommand cmd = new ExpansionCommand(ExpansionState.EXPAND, element);
        this.expansionStack.add(cmd);
        this.updateExpansionState();
    }

    public void expandAll() {
        ExpansionCommand cmd = new ExpansionCommand(ExpansionState.FULLY_EXPAND, null);
        this.expansionStack.add(cmd);
        this.updateExpansionState();
    }

    public void removeDoubleClickListener(IActionListener listener) {
        if (this.doubleClickListeners != null) {
            this.doubleClickListeners.remove((Object)listener);
        }
    }

    @Override
    public boolean containsOption(Object option) {
        this.reveal(new Object[]{option});
        return super.containsOption(option);
    }

    @Override
    public final void setSelection(List<?> newSelection) {
        this.reveal(newSelection.toArray());
        super.setSelection(newSelection);
        this.saveSelection();
    }

    public boolean getRootsVisible() {
        return this.showRoots;
    }

    public void setRootsVisible(boolean showRoots) {
        this.showRoots = showRoots;
    }

    public void updateFromModel() {
        this.treeRoots = new Object[this.model.length];
        System.arraycopy(this.model, 0, this.treeRoots, 0, this.treeRoots.length);
        if (this.viewer != null) {
            List<Object> selection = this.getSelection();
            Object[] expandedElements = this.viewer.getExpandedElements();
            this.viewer.getControl().setRedraw(false);
            try {
                this.viewer.setInput(null);
                if (this.showRoots) {
                    this.viewer.setInput((Object)this.treeRoots);
                } else {
                    FakeRoot fakeRoot = new FakeRoot(this.treeRoots[0], this.childrenAccessor);
                    this.viewer.setInput((Object)fakeRoot);
                }
                this.viewer.setExpandedElements(expandedElements);
                TreeRidgetLabelProvider labelProvider = (TreeRidgetLabelProvider)this.viewer.getLabelProvider();
                IColumnFormatter[] formatters = this.getColumnFormatters(labelProvider.getColumnCount());
                labelProvider.setFormatters(formatters);
                this.viewer.refresh();
                this.viewer.setSelection((ISelection)new StructuredSelection(selection));
            }
            finally {
                this.viewer.getControl().setRedraw(true);
            }
        }
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    private void applyEraseListener() {
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            control.removeListener(40, ERASE_LISTENER);
            if (!this.isEnabled() && MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
                control.addListener(40, ERASE_LISTENER);
                control.addListener(42, ERASE_LISTENER);
            }
        }
    }

    private void applyTableColumnHeaders(Tree control) {
        boolean headersVisible = this.columnHeaders != null;
        control.setHeaderVisible(headersVisible);
        if (headersVisible) {
            TreeColumn[] columns = control.getColumns();
            int i = 0;
            while (i < columns.length) {
                String columnHeader = "";
                if (i < this.columnHeaders.length && this.columnHeaders[i] != null) {
                    columnHeader = this.columnHeaders[i];
                }
                columns[i].setText(columnHeader);
                ++i;
            }
        }
    }

    private void bindToViewer(Tree control) {
        this.viewer = new TreeViewer(control);
        final Realm realm = SWTObservables.getRealm((Display)Display.getDefault());
        IObservableFactory listFactory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof Object[]) {
                    return Observables.staticObservableList((Realm)realm, Arrays.asList((Object[])target));
                }
                Object value = target instanceof FakeRoot ? ((FakeRoot)target).getRoot() : target;
                if (AbstractSWTWidgetRidget.isBean(TreeRidget.this.treeElementClass)) {
                    return BeansObservables.observeList((Realm)realm, (Object)value, (String)TreeRidget.this.childrenAccessor, (Class)TreeRidget.this.treeElementClass);
                }
                return PojoObservables.observeList((Realm)realm, (Object)value, (String)TreeRidget.this.childrenAccessor, (Class)TreeRidget.this.treeElementClass);
            }
        };
        GenericTreeStructureAdvisor structureAdvisor = new GenericTreeStructureAdvisor(this.parentAccessor, this.treeElementClass);
        ObservableListTreeContentProvider viewerCP = new ObservableListTreeContentProvider(listFactory, (TreeStructureAdvisor)structureAdvisor);
        this.viewer.setContentProvider((IContentProvider)viewerCP);
        viewerCP.getKnownElements().addSetChangeListener((ISetChangeListener)new TreeContentChangeListener(this.viewer, structureAdvisor));
        IColumnFormatter[] formatters = this.getColumnFormatters(this.valueAccessors.length);
        TreeRidgetLabelProvider viewerLP = TreeRidgetLabelProvider.createLabelProvider(this.viewer, this.treeElementClass, viewerCP.getKnownElements(), this.valueAccessors, this.enablementAccessor, this.imageAccessor, formatters);
        this.viewer.setLabelProvider((IBaseLabelProvider)viewerLP);
        if (this.showRoots) {
            this.viewer.setInput((Object)this.treeRoots);
        } else {
            FakeRoot fakeRoot = new FakeRoot(this.treeRoots[0], this.childrenAccessor);
            this.viewer.setInput((Object)fakeRoot);
        }
        IObservableMap enablementAttr = this.createObservableAttribute(viewerCP, this.enablementAccessor);
        this.preventDisabledItemSelection(enablementAttr);
        IObservableMap visibilityAttr = this.createObservableAttribute(viewerCP, this.visibilityAccessor);
        this.monitorVisibility(this.viewer, structureAdvisor, visibilityAttr);
    }

    private void bindToSelection() {
        this.dbc = new DataBindingContext();
        IViewerObservableValue viewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.viewer);
        this.dbc.bindValue((IObservableValue)viewerSelection, this.getSingleSelectionObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new OutputAwareValidator((IMarkableRidget)this)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.viewerMSB = null;
        if (!this.isOutputOnly()) {
            this.createMultipleSelectionBinding();
        }
        this.saveSelection();
    }

    private void checkColumns(Tree control) {
        int columnCount = control.getColumnCount() == 0 ? 1 : control.getColumnCount();
        String message = String.format("Tree has %d columns, expected: %d", columnCount, this.valueAccessors.length);
        Assert.isLegal((columnCount == this.valueAccessors.length ? 1 : 0) != 0, (String)message);
    }

    private void createMultipleSelectionBinding() {
        if (this.viewerMSB == null && this.dbc != null && this.viewer != null) {
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            IViewerObservableList viewerSelections = ViewersObservables.observeMultiSelection((Viewer)this.viewer);
            this.viewerMSB = this.dbc.bindList((IObservableList)viewerSelections, this.getMultiSelectionObservable(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
            this.viewer.setSelection((ISelection)currentSelection);
        }
    }

    private IObservableMap createObservableAttribute(ObservableListTreeContentProvider viewerCP, String accessor) {
        IObservableMap result = null;
        if (accessor != null) {
            result = AbstractSWTWidgetRidget.isBean(this.treeElementClass) ? BeansObservables.observeMap((IObservableSet)viewerCP.getKnownElements(), this.treeElementClass, (String)accessor) : PojoObservables.observeMap((IObservableSet)viewerCP.getKnownElements(), this.treeElementClass, (String)accessor);
        }
        return result;
    }

    private void disposeMultipleSelectionBinding() {
        if (this.viewerMSB != null) {
            this.viewerMSB.dispose();
            this.dbc.removeBinding(this.viewerMSB);
            this.viewerMSB = null;
        }
    }

    private void monitorVisibility(final TreeViewer viewer, final TreeStructureAdvisor structureAdvisor, final IObservableMap visibilityAttr) {
        if (visibilityAttr != null) {
            viewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    Object visible = visibilityAttr.get(element);
                    return !Boolean.FALSE.equals(visible);
                }
            });
            IMapChangeListener mapChangeListener = new IMapChangeListener(){

                public void handleMapChange(MapChangeEvent event) {
                    Set affectedElements = event.diff.getChangedKeys();
                    for (Object element : affectedElements) {
                        Object parent = structureAdvisor.getParent(element);
                        if (parent == null || parent == TreeRidget.this.treeRoots[0] && !TreeRidget.this.showRoots) {
                            viewer.refresh();
                            continue;
                        }
                        viewer.refresh(parent);
                    }
                }
            };
            visibilityAttr.addMapChangeListener(mapChangeListener);
        }
    }

    private void preventDisabledItemSelection(final IObservableMap enablementAttr) {
        if (enablementAttr != null) {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){
                private List<Object> lastSel;

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ArrayList<Object> newSel = new ArrayList<Object>(selection.toList());
                    boolean changed = false;
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        Object isEnabled = enablementAttr.get(element);
                        if (Boolean.FALSE.equals(isEnabled)) {
                            newSel.remove(element);
                            changed = true;
                        }
                        ++n2;
                    }
                    if (changed) {
                        if (newSel.isEmpty() && this.lastSel != null) {
                            TreeRidget.this.viewer.setSelection((ISelection)new StructuredSelection(this.lastSel));
                            TreeRidget.this.setSelection(this.lastSel);
                        } else {
                            TreeRidget.this.viewer.setSelection((ISelection)new StructuredSelection(newSel));
                            TreeRidget.this.setSelection(newSel);
                            this.lastSel = newSel;
                        }
                    } else {
                        this.lastSel = newSel;
                    }
                }
            });
        }
    }

    private void reveal(Object[] candidates) {
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            control.setRedraw(false);
            try {
                Object[] objectArray = candidates;
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object candidate = objectArray[n2];
                    this.viewer.expandToLevel(candidate, 0);
                    ++n2;
                }
            }
            finally {
                control.setRedraw(true);
            }
        }
    }

    private synchronized void saveSelection() {
        this.savedSelection = this.viewer != null && this.isOutputOnly() ? this.viewer.getTree().getSelection() : new TreeItem[0];
    }

    private synchronized void restoreSelection() {
        if (this.viewer != null) {
            Tree control = this.viewer.getTree();
            control.deselectAll();
            TreeItem[] treeItemArray = this.savedSelection;
            int n = this.savedSelection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                control.select(item);
                ++n2;
            }
        }
    }

    private void updateExpansionState() {
        if (this.viewer != null) {
            this.viewer.getControl().setRedraw(false);
            try {
                while (!this.expansionStack.isEmpty()) {
                    ExpansionCommand cmd = this.expansionStack.remove();
                    ExpansionState state = cmd.state;
                    if (state == ExpansionState.FULLY_COLLAPSE) {
                        Object[] expanded = this.viewer.getExpandedElements();
                        this.viewer.collapseAll();
                        Object[] objectArray = expanded;
                        int n = expanded.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object wasExpanded = objectArray[n2];
                            this.viewer.update(wasExpanded, null);
                            ++n2;
                        }
                        continue;
                    }
                    if (state == ExpansionState.FULLY_EXPAND) {
                        this.viewer.expandAll();
                        this.viewer.refresh();
                        continue;
                    }
                    if (state == ExpansionState.COLLAPSE) {
                        this.viewer.collapseToLevel(cmd.element, 1);
                        this.viewer.update(cmd.element, null);
                        continue;
                    }
                    if (state == ExpansionState.EXPAND) {
                        this.viewer.expandToLevel(cmd.element, 1);
                        this.viewer.update(cmd.element, null);
                        continue;
                    }
                    if (state == ExpansionState.RESTORE) {
                        Object[] elements = (Object[])cmd.element;
                        this.viewer.setExpandedElements(elements);
                        continue;
                    }
                    String errorMsg = "unknown expansion state: " + (Object)((Object)state);
                    throw new IllegalStateException(errorMsg);
                }
            }
            finally {
                this.viewer.getControl().setRedraw(true);
            }
        }
    }

    private final class DoubleClickForwarder
    extends MouseAdapter {
        private DoubleClickForwarder() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (TreeRidget.this.doubleClickListeners != null) {
                IActionListener[] iActionListenerArray = (IActionListener[])TreeRidget.this.doubleClickListeners.getListeners();
                int n = iActionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IActionListener listener = iActionListenerArray[n2];
                    listener.callback();
                    ++n2;
                }
            }
        }
    }

    private static final class EraseAndPaintListener
    implements Listener {
        private Rectangle bounds = new Rectangle(0, 0, 0, 0);

        private EraseAndPaintListener() {
        }

        public void handleEvent(Event event) {
            TreeItem item;
            Tree tree;
            if (40 == event.type) {
                event.detail &= 0xFFFFFFEF;
            } else if (42 == event.type && !(tree = (item = (TreeItem)event.item).getParent()).isEnabled()) {
                GC gc = event.gc;
                this.bounds.width = tree.getBounds().width;
                this.bounds.height = tree.getBounds().height;
                gc.fillRectangle(this.bounds);
            }
        }
    }

    private static final class ExpansionCommand {
        private final ExpansionState state;
        private final Object element;

        ExpansionCommand(ExpansionState state, Object element) {
            this.state = state;
            this.element = element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExpansionState {
        FULLY_COLLAPSE,
        FULLY_EXPAND,
        COLLAPSE,
        EXPAND,
        RESTORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FakeRoot
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;
        private final String accessor;
        private final Object root0;

        FakeRoot(Object root0, String childrenAccessor) {
            Assert.isNotNull((Object)root0);
            Assert.isNotNull((Object)childrenAccessor);
            this.root0 = root0;
            this.accessor = "get" + this.capitalize(childrenAccessor);
            this.clear();
            this.addAll((Collection)ReflectionUtils.invoke((Object)root0, (String)this.accessor, (Object[])new Object[0]));
        }

        Object getRoot() {
            return this.root0;
        }

        private String capitalize(String name) {
            String result = name.substring(0, 1).toUpperCase();
            if (name.length() > 1) {
                result = String.valueOf(result) + name.substring(1);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GenericTreeStructureAdvisor
    extends TreeStructureAdvisor {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private final Class<?> beanClass;
        private PropertyDescriptor descriptor;

        GenericTreeStructureAdvisor(String propertyName, Class<?> elementClass) {
            Assert.isNotNull((Object)propertyName);
            String errorMsg = "propertyName cannot be empty";
            Assert.isLegal((propertyName.trim().length() > 0 ? 1 : 0) != 0, (String)errorMsg);
            Assert.isNotNull(elementClass);
            String readMethodName = "get" + this.capitalize(propertyName);
            try {
                this.descriptor = new PropertyDescriptor(propertyName, elementClass, readMethodName, null);
            }
            catch (IntrospectionException exc) {
                this.log("Could not introspect bean.", exc);
                this.descriptor = null;
            }
            this.beanClass = elementClass;
        }

        public Object getParent(Object element) {
            Object result = null;
            if (element != null && this.beanClass.isAssignableFrom(element.getClass()) && this.descriptor != null) {
                Method readMethod = this.descriptor.getReadMethod();
                if (!readMethod.isAccessible()) {
                    readMethod.setAccessible(true);
                }
                try {
                    result = readMethod.invoke(element, EMPTY_ARRAY);
                }
                catch (InvocationTargetException exc) {
                    this.log("Error invoking.", exc);
                }
                catch (IllegalAccessException exc) {
                    this.log("Error invoking.", exc);
                }
            }
            return result;
        }

        private String capitalize(String name) {
            String result = name.substring(0, 1).toUpperCase();
            if (name.length() > 1) {
                result = String.valueOf(result) + name.substring(1);
            }
            return result;
        }

        private void log(String message, Exception exc) {
            Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), TreeRidget.class);
            logger.log(1, message, (Throwable)exc);
        }
    }

    private final class SelectionTypeEnforcer
    extends SelectionAdapter {
        private SelectionTypeEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            Tree control = (Tree)e.widget;
            if (TreeRidget.this.isOutputOnly()) {
                e.doit = false;
                TreeRidget.this.restoreSelection();
            } else if (ISelectableRidget.SelectionType.SINGLE.equals((Object)TreeRidget.this.getSelectionType()) && control.getSelectionCount() > 1) {
                e.doit = false;
                TreeItem firstItem = control.getSelection()[0];
                control.setSelection(firstItem);
                Event event = new Event();
                event.type = 13;
                event.doit = true;
                control.notifyListeners(13, event);
            }
        }
    }

    private static final class TreeContentChangeListener
    implements ISetChangeListener {
        private final TreeViewer viewer;
        private final TreeStructureAdvisor structureAdvisor;

        private TreeContentChangeListener(TreeViewer viewer, TreeStructureAdvisor structureAdvisor) {
            Assert.isNotNull((Object)structureAdvisor);
            this.structureAdvisor = structureAdvisor;
            this.viewer = viewer;
            Assert.isNotNull((Object)viewer.getContentProvider());
        }

        public void handleSetChange(SetChangeEvent event) {
            Object parent;
            if (this.viewer.getLabelProvider(0) == null) {
                return;
            }
            HashSet<Object> parents = new HashSet<Object>();
            for (Object e : event.diff.getAdditions()) {
                parent = this.structureAdvisor.getParent(e);
                if (parent == null) continue;
                parents.add(parent);
            }
            for (Object e : event.diff.getRemovals()) {
                parent = this.structureAdvisor.getParent(e);
                if (parent == null) continue;
                parents.add(parent);
            }
            for (Object e : parents) {
                if (this.viewer.isBusy()) continue;
                this.viewer.update(e, null);
            }
        }
    }
}

