/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.util.Comparator;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeTableRidget;
import org.eclipse.riena.tests.TreeUtils;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeTableRidgetTest
extends AbstractSWTRidgetTest {
    private PersonNode[] roots;
    private PersonNode node1;
    private PersonNode node2;
    private PersonNode node3;
    private PersonNode node4;

    protected void setUp() throws Exception {
        super.setUp();
        this.roots = this.initializeTreeModel();
        String[] valueAccessors = new String[]{"firstname", "lastname"};
        String[] columnHeaders = new String[]{"First Name", "Last Name"};
        this.getRidget().bindToModel((Object[])this.roots, PersonNode.class, "children", "parent", valueAccessors, columnHeaders);
    }

    protected Control createWidget(Composite parent) {
        Tree result = new Tree(parent, 2);
        result.setHeaderVisible(true);
        new TreeColumn(result, 0);
        new TreeColumn(result, 0);
        return result;
    }

    protected IRidget createRidget() {
        return new TreeTableRidget();
    }

    protected Tree getWidget() {
        return (Tree)super.getWidget();
    }

    protected TreeTableRidget getRidget() {
        return (TreeTableRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        TreeTableRidgetTest.assertSame(TreeTableRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testBindToModel() {
        TreeTableRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.expandAll();
        TreeTableRidgetTest.assertEquals((int)9, (int)TreeUtils.getItemCount(control));
        TreeTableRidgetTest.assertEquals((String)this.node1.getFirstname(), (String)this.getUIControlItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)this.node2.getFirstname(), (String)this.getUIControlItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)this.node3.getFirstname(), (String)this.getUIControlItem(2).getText(0));
        TreeTableRidgetTest.assertEquals((String)this.node4.getFirstname(), (String)this.getUIControlItem(3).getText(0));
        TreeTableRidgetTest.assertEquals((String)this.node1.getLastname(), (String)this.getUIControlItem(0).getText(1));
        TreeTableRidgetTest.assertEquals((String)this.node2.getLastname(), (String)this.getUIControlItem(1).getText(1));
        TreeTableRidgetTest.assertEquals((String)this.node3.getLastname(), (String)this.getUIControlItem(2).getText(1));
        TreeTableRidgetTest.assertEquals((String)this.node4.getLastname(), (String)this.getUIControlItem(3).getText(1));
    }

    public void testBindToModelTooFewColumns() {
        Tree control = this.getWidget();
        TreeTableRidgetTest.assertEquals((int)2, (int)control.getColumnCount());
        try {
            this.getRidget().bindToModel((Object[])this.roots, PersonNode.class, "children", "parent", new String[]{"firstname"}, new String[]{"First Name"});
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testBindToModelWithTooManyColumns() {
        Tree control = this.getWidget();
        TreeTableRidgetTest.assertEquals((int)2, (int)control.getColumnCount());
        try {
            this.getRidget().bindToModel((Object[])this.roots, PersonNode.class, "children", "parent", new String[]{"firstname", "lastname", "entry"}, new String[]{"First Name", "Last Name", "First - Last"});
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            this.getRidget().setUIControl((Object)new Tree((Composite)this.getShell(), 0));
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testTableColumnsNumAndHeader() {
        Tree control = this.getWidget();
        TreeColumn[] columns = control.getColumns();
        TreeTableRidgetTest.assertEquals((int)2, (int)columns.length);
        TreeTableRidgetTest.assertEquals((String)"First Name", (String)columns[0].getText());
        TreeTableRidgetTest.assertEquals((String)"Last Name", (String)columns[1].getText());
        TreeTableRidgetTest.assertTrue((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsNumAndHeaderWithMismatch() {
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] headers1 = new String[]{"First Name"};
        try {
            this.getRidget().bindToModel((Object[])this.roots, PersonNode.class, "children", "parent", properties1, headers1);
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testTableColumnsWithNullHeader() {
        Tree control = this.getWidget();
        control.setHeaderVisible(true);
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        this.getRidget().bindToModel((Object[])this.roots, PersonNode.class, "children", "parent", properties1, null);
        TreeTableRidgetTest.assertFalse((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsWithNullHeaderEntry() {
        Tree control = this.getWidget();
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] stringArray = new String[2];
        stringArray[0] = "First Name";
        String[] headers = stringArray;
        this.getRidget().bindToModel((Object[])this.roots, PersonNode.class, "children", "parent", properties1, headers);
        TreeTableRidgetTest.assertEquals((String)"First Name", (String)control.getColumn(0).getText());
        TreeTableRidgetTest.assertEquals((String)"", (String)control.getColumn(1).getText());
    }

    public void testSetGroupingEnabled() {
        TreeTableRidget ridget = this.getRidget();
        TreeTableRidgetTest.assertFalse((boolean)ridget.isGroupingEnabled());
        ridget.setGroupingEnabled(true);
        TreeTableRidgetTest.assertTrue((boolean)ridget.isGroupingEnabled());
        ridget.setGroupingEnabled(false);
        TreeTableRidgetTest.assertFalse((boolean)ridget.isGroupingEnabled());
    }

    public void testSetGroupingEnabledFiresEvents() {
        TreeTableRidget ridget = this.getRidget();
        this.expectPropertyChangeEvent("groupingEnabled", Boolean.FALSE, Boolean.TRUE);
        ridget.setGroupingEnabled(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setGroupingEnabled(true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("groupingEnabled", Boolean.TRUE, Boolean.FALSE);
        ridget.setGroupingEnabled(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setGroupingEnabled(false);
        this.verifyPropertyChangeEvents();
    }

    public void testSetComparator() {
        TreeTableRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TypedComparator comparator = new TypedComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparator);
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setComparator(2, (Comparator)comparator);
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setSortedAscending(true);
        TreeTableRidgetTest.assertEquals((String)"Benjamin", (String)control.getItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Zebra", (String)control.getItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Adam", (String)control.getItem(2).getText(0));
        ridget.setComparator(0, (Comparator)comparator);
        TreeTableRidgetTest.assertEquals((String)"Benjamin", (String)control.getItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Zebra", (String)control.getItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Adam", (String)control.getItem(2).getText(0));
        ridget.setSortedColumn(0);
        TreeTableRidgetTest.assertEquals((String)"Adam", (String)control.getItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Benjamin", (String)control.getItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Zebra", (String)control.getItem(2).getText(0));
        ridget.setComparator(0, null);
        TreeTableRidgetTest.assertEquals((String)"Benjamin", (String)control.getItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Zebra", (String)control.getItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Adam", (String)control.getItem(2).getText(0));
    }

    public void testGetSortedColumn() {
        TreeTableRidget ridget = this.getRidget();
        try {
            ridget.setSortedColumn(2);
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(1, (Comparator)new TypedComparator());
        ridget.setSortedColumn(1);
        TreeTableRidgetTest.assertEquals((int)1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        TreeTableRidget ridget = this.getRidget();
        try {
            TreeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            TreeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(2));
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int i = 0;
        while (i < 2) {
            TreeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, (Comparator)new TypedComparator());
            TreeTableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, false);
            TreeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, true);
            TreeTableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, null);
            TreeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ++i;
        }
    }

    public void testSetSortedAscending() {
        Tree control = this.getWidget();
        TreeTableRidget ridget = this.getRidget();
        ridget.bindToModel((Object[])this.roots, PersonNode.class, "children", "parent", new String[]{"firstname", "lastname"}, null);
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TreeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setSortedColumn(0);
        TreeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        TreeTableRidgetTest.assertEquals((String)"Adam", (String)control.getItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Benjamin", (String)control.getItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Zebra", (String)control.getItem(2).getText(0));
        ridget.setSortedAscending(false);
        TreeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        TreeTableRidgetTest.assertEquals((String)"Zebra", (String)control.getItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Benjamin", (String)control.getItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Adam", (String)control.getItem(2).getText(0));
        ridget.setSortedAscending(true);
        TreeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        TreeTableRidgetTest.assertEquals((String)"Adam", (String)control.getItem(0).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Benjamin", (String)control.getItem(1).getText(0));
        TreeTableRidgetTest.assertEquals((String)"Zebra", (String)control.getItem(2).getText(0));
        ridget.setComparator(0, null);
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TreeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        TreeTableRidget ridget = this.getRidget();
        ridget.setSortedAscending(true);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        TreeTableRidget ridget = this.getRidget();
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, 1));
        ridget.setSortedColumn(1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetColumnSortabilityFiresEvents() {
        TreeTableRidget ridget = this.getRidget();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
    }

    public void testColumnHeaderChangesSortability() {
        TreeTableRidget ridget = this.getRidget();
        Tree tree = this.getWidget();
        ridget.setColumnSortable(0, true);
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setColumnSortable(1, true);
        ridget.setComparator(1, (Comparator)new TypedComparator());
        ridget.setSortedColumn(-1);
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TreeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        Event e = new Event();
        e.type = 13;
        e.widget = tree.getColumn(0);
        e.widget.notifyListeners(13, e);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TreeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TreeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TreeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TreeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TreeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testSortColumnTwo() {
        TreeTableRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        WordNode root = new WordNode("root");
        new WordNode(root, "ZA");
        new WordNode(root, "AAA");
        new WordNode(root, "BCAA");
        ridget.bindToModel(new Object[]{root}, WordNode.class, "children", "parent", new String[]{"word", "ACount"}, null);
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setComparator(1, (Comparator)new TypedComparator());
        ridget.expandAll();
        TreeTableRidgetTest.assertEquals((String)"ZA", (String)control.getItem(0).getItem(0).getText());
        TreeTableRidgetTest.assertEquals((String)"AAA", (String)control.getItem(0).getItem(1).getText());
        TreeTableRidgetTest.assertEquals((String)"BCAA", (String)control.getItem(0).getItem(2).getText());
        ridget.setSortedColumn(0);
        ridget.setSortedAscending(true);
        TreeTableRidgetTest.assertEquals((String)"AAA", (String)control.getItem(0).getItem(0).getText());
        TreeTableRidgetTest.assertEquals((String)"BCAA", (String)control.getItem(0).getItem(1).getText());
        TreeTableRidgetTest.assertEquals((String)"ZA", (String)control.getItem(0).getItem(2).getText());
        ridget.setSortedColumn(1);
        TreeTableRidgetTest.assertEquals((String)"ZA", (String)control.getItem(0).getItem(0).getText());
        TreeTableRidgetTest.assertEquals((String)"BCAA", (String)control.getItem(0).getItem(1).getText());
        TreeTableRidgetTest.assertEquals((String)"AAA", (String)control.getItem(0).getItem(2).getText());
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        TreeTableRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeTableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeTableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TreeTableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeTableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        TreeTableRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeTableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeTableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TreeTableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeTableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        TreeTableRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.node1);
        TreeTableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ridget.setOutputOnly(true);
        TreeTableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ridget.setSelection(null);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ridget.setOutputOnly(false);
        TreeTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
    }

    public void testSetColumnFormatter() {
        TreeTableRidget ridget = this.getRidget();
        Tree tree = this.getWidget();
        ColumnFormatter formatter = new ColumnFormatter(){

            public String getText(Object element) {
                PersonNode node = (PersonNode)((Object)element);
                return node.getLastname().toUpperCase();
            }
        };
        String lastName = this.node1.getLastname();
        String lastNameUpperCase = lastName.toUpperCase();
        try {
            ridget.setColumnFormatter(-1, (IColumnFormatter)formatter);
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setColumnFormatter(99, (IColumnFormatter)formatter);
            TreeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setColumnFormatter(1, (IColumnFormatter)formatter);
        TreeTableRidgetTest.assertEquals((String)lastName, (String)tree.getItem(0).getText(1));
        ridget.updateFromModel();
        TreeTableRidgetTest.assertEquals((String)lastNameUpperCase, (String)tree.getItem(0).getText(1));
        ridget.setColumnFormatter(1, null);
        TreeTableRidgetTest.assertEquals((String)lastNameUpperCase, (String)tree.getItem(0).getText(1));
        ridget.updateFromModel();
        TreeTableRidgetTest.assertEquals((String)lastName, (String)tree.getItem(0).getText(1));
    }

    private PersonNode[] initializeTreeModel() {
        PersonNode root1;
        this.node1 = root1 = new PersonNode(new Person("Root", "Benjamin"));
        PersonNode root2 = new PersonNode(new Person("Root", "Zebra"));
        PersonNode root3 = new PersonNode(new Person("Root", "Adam"));
        this.node2 = new PersonNode(this.node1, new Person("Benjason", "Elen"));
        this.node4 = new PersonNode(this.node1, new Person("Benjason", "Zora"));
        new PersonNode(this.node1, new Person("Benjason", "Anna"));
        this.node3 = new PersonNode(this.node2, new Person("Zebrason", "Ben"));
        new PersonNode(this.node2, new Person("Zebrason", "Zulu"));
        new PersonNode(this.node2, new Person("Zebrason", "Arno"));
        return new PersonNode[]{root1, root2, root3};
    }

    private TreeItem getUIControlItem(int index) {
        this.getRidget().expandAll();
        Tree control = this.getWidget();
        switch (index) {
            case 0: {
                return control.getItem(0);
            }
            case 1: {
                return control.getItem(0).getItem(0);
            }
            case 2: {
                return control.getItem(0).getItem(0).getItem(0);
            }
            case 3: {
                return control.getItem(0).getItem(1);
            }
        }
        throw new IndexOutOfBoundsException("index= " + index);
    }

    private static final class PersonNode
    extends TreeNode {
        public PersonNode(Person value) {
            super((Object)value);
        }

        public PersonNode(PersonNode parent, Person value) {
            super((ITreeNode)parent, (Object)value);
        }

        public String getFirstname() {
            return ((Person)this.getValue()).getFirstname();
        }

        public String getLastname() {
            return ((Person)this.getValue()).getLastname();
        }

        public String getEntry() {
            return ((Person)this.getValue()).getListEntry();
        }
    }
}

