/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.tests;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class TreeUtils {
    private static int level = 0;

    private TreeUtils() {
    }

    public static int getItemCount(Tree control) {
        int count = 0;
        TreeItem[] treeItemArray = control.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem root = treeItemArray[n2];
            count += TreeUtils.getItemCount(root);
            ++n2;
        }
        return count;
    }

    public static int getItemCount(TreeItem item) {
        int count = 0;
        if (item != null) {
            ++count;
            if (item.getExpanded()) {
                TreeItem[] treeItemArray = item.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem child = treeItemArray[n2];
                    count += TreeUtils.getItemCount(child);
                    ++n2;
                }
            }
        }
        return count;
    }

    public static synchronized void print(TreeItem item) {
        TreeUtils.printSpaces(level);
        System.out.println(item);
        ++level;
        try {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                TreeUtils.print(child);
                ++n2;
            }
        }
        finally {
            --level;
        }
    }

    public static synchronized void print(Tree tree) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            TreeUtils.print(child);
            ++n2;
        }
        System.out.println("###");
    }

    private static void printSpaces(int numSpaces) {
        Assert.isLegal((numSpaces >= 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < numSpaces) {
            System.out.print(" ");
            ++i;
        }
    }
}

