/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.utils.DetachedViewsManager;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.ViewPart;

@UITestCase
public class DetachedViewsManagerTest
extends RienaTestCase {
    private static int COUNT = 0;
    private Display display;
    private Shell shell;
    private DetachedViewsManager manager;
    private IWorkbenchSite site;

    protected void setUp() {
        COUNT = 0;
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
        this.site = new Site(this.shell);
        this.manager = new DetachedViewsManager(this.site);
    }

    protected void tearDown() {
        this.display.dispose();
        this.shell.dispose();
        this.manager.dispose();
    }

    public void testShowView() {
        DetachedViewsManagerTest.assertEquals((int)0, (int)COUNT);
        this.manager.showView("viewOne", FTViewPart.class, 128);
        this.manager.showView("viewOne", FTViewPart.class, 128);
        DetachedViewsManagerTest.assertEquals((int)1, (int)COUNT);
        this.manager.showView("viewTwo", FTViewPart.class, 1024);
        DetachedViewsManagerTest.assertEquals((int)2, (int)COUNT);
        try {
            this.manager.showView("  ", FTViewPart.class, 1);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
        try {
            this.manager.showView(null, FTViewPart.class, 1);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
        try {
            this.manager.showView("", FTViewPart.class, 1);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
        try {
            this.manager.showView("viewThree", null, 128);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
        try {
            this.manager.showView("viewThree", FTViewPart.class, -1);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
    }

    public void testShowViewWithBounds() {
        this.manager.showView("viewOne", FTViewPart.class, new Rectangle(20, 30, 400, 500));
        Shell shell = this.manager.getShell("viewOne");
        Rectangle shellBounds = shell.getBounds();
        DetachedViewsManagerTest.assertEquals((int)20, (int)shellBounds.x);
        DetachedViewsManagerTest.assertEquals((int)30, (int)shellBounds.y);
        DetachedViewsManagerTest.assertEquals((int)400, (int)shellBounds.width);
        DetachedViewsManagerTest.assertEquals((int)500, (int)shellBounds.height);
    }

    public void testHideView() {
        this.manager.showView("viewOne", FTViewPart.class, 128);
        Shell viewOne = this.manager.getShell("viewOne");
        DetachedViewsManagerTest.assertEquals((int)1, (int)COUNT);
        DetachedViewsManagerTest.assertTrue((boolean)viewOne.isVisible());
        this.manager.hideView("viewOne");
        DetachedViewsManagerTest.assertEquals((int)1, (int)COUNT);
        DetachedViewsManagerTest.assertFalse((boolean)viewOne.isVisible());
        DetachedViewsManagerTest.assertFalse((boolean)this.shell.isDisposed());
        this.manager.showView("viewOne", FTViewPart.class, 128);
        DetachedViewsManagerTest.assertEquals((int)1, (int)COUNT);
        DetachedViewsManagerTest.assertTrue((boolean)viewOne.isVisible());
        DetachedViewsManagerTest.assertFalse((boolean)this.shell.isDisposed());
        try {
            this.manager.hideView(null);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
    }

    public void testCloseView() {
        this.manager.showView("viewOne", FTViewPart.class, 128);
        this.manager.showView("viewTwo", FTViewPart.class, 1024);
        Shell viewOne = this.manager.getShell("viewOne");
        Shell viewTwo = this.manager.getShell("viewTwo");
        DetachedViewsManagerTest.assertEquals((int)2, (int)COUNT);
        DetachedViewsManagerTest.assertTrue((boolean)viewOne.isVisible());
        DetachedViewsManagerTest.assertTrue((boolean)viewTwo.isVisible());
        DetachedViewsManagerTest.assertFalse((boolean)viewOne.isDisposed());
        DetachedViewsManagerTest.assertFalse((boolean)viewTwo.isDisposed());
        this.manager.closeView("viewTwo");
        DetachedViewsManagerTest.assertEquals((int)1, (int)COUNT);
        DetachedViewsManagerTest.assertTrue((boolean)viewOne.isVisible());
        DetachedViewsManagerTest.assertFalse((boolean)viewOne.isDisposed());
        DetachedViewsManagerTest.assertTrue((boolean)viewTwo.isDisposed());
        this.manager.closeView("viewOne");
        DetachedViewsManagerTest.assertEquals((int)0, (int)COUNT);
        DetachedViewsManagerTest.assertTrue((boolean)viewOne.isDisposed());
        DetachedViewsManagerTest.assertTrue((boolean)viewTwo.isDisposed());
        this.manager.closeView("viewOne");
        try {
            this.manager.closeView(null);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
    }

    public void testDispose() {
        this.manager.showView("viewOne", FTViewPart.class, 128);
        this.manager.showView("viewTwo", FTViewPart.class, 1024);
        DetachedViewsManagerTest.assertEquals((int)2, (int)COUNT);
        this.manager.dispose();
        DetachedViewsManagerTest.assertEquals((int)0, (int)COUNT);
    }

    public void testGetShell() {
        DetachedViewsManagerTest.assertNull((Object)this.manager.getShell("viewOne"));
        this.manager.showView("viewOne", FTViewPart.class, 128);
        Shell shell = this.manager.getShell("viewOne");
        DetachedViewsManagerTest.assertNotNull((Object)shell);
        this.manager.hideView("viewOne");
        DetachedViewsManagerTest.assertSame((Object)shell, (Object)this.manager.getShell("viewOne"));
        this.manager.closeView("viewOne");
        DetachedViewsManagerTest.assertNull((Object)this.manager.getShell("viewOne"));
        try {
            this.manager.getShell(null);
            DetachedViewsManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
    }

    public void testCreateController() {
        Boolean result = (Boolean)ReflectionUtils.invokeHidden((Object)this.manager, (String)"checkController", (Object[])new Object[]{new FTViewPart()});
        DetachedViewsManagerTest.assertTrue((boolean)result);
        result = (Boolean)ReflectionUtils.invokeHidden((Object)this.manager, (String)"checkController", (Object[])new Object[]{new FTViewWithController()});
        DetachedViewsManagerTest.assertTrue((boolean)result);
        result = (Boolean)ReflectionUtils.invokeHidden((Object)this.manager, (String)"checkController", (Object[])new Object[]{new FTViewWithoutController()});
        DetachedViewsManagerTest.assertFalse((boolean)result);
    }

    public static final class FTViewController
    extends SubModuleController {
    }

    public static final class FTViewPart
    extends ViewPart {
        public void createPartControl(Composite parent) {
            COUNT = COUNT + 1;
        }

        public void dispose() {
            COUNT = COUNT - 1;
            super.dispose();
        }

        public void setFocus() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FTViewWithController
    extends SubModuleView<FTViewController> {
        private FTViewController controller = new FTViewController();

        protected FTViewController createController(ISubModuleNode node) {
            return this.controller;
        }

        protected void basicCreatePartControl(Composite parent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FTViewWithoutController
    extends SubModuleView<FTViewController> {
        protected void basicCreatePartControl(Composite parent) {
        }
    }

    private static final class Site
    implements IWorkbenchSite {
        private final Shell shell;
        private IWorkbenchWindow window;

        public Site(Shell shell) {
            this.shell = shell;
        }

        public IWorkbenchPage getPage() {
            return null;
        }

        public ISelectionProvider getSelectionProvider() {
            return null;
        }

        public Shell getShell() {
            return this.shell;
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            if (this.window == null) {
                this.window = new WorkbenchWindow(this.shell);
            }
            return this.window;
        }

        public void setSelectionProvider(ISelectionProvider provider) {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public Object getService(Class api) {
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    }

    private static final class WorkbenchWindow
    implements IWorkbenchWindow {
        private final Shell shell;

        public WorkbenchWindow(Shell shell) {
            this.shell = shell;
        }

        public boolean close() {
            this.shell.close();
            return true;
        }

        public IWorkbenchPage getActivePage() {
            return null;
        }

        public IExtensionTracker getExtensionTracker() {
            return null;
        }

        public IWorkbenchPage[] getPages() {
            return null;
        }

        public IPartService getPartService() {
            return null;
        }

        public ISelectionService getSelectionService() {
            return null;
        }

        public Shell getShell() {
            return this.shell;
        }

        public IWorkbench getWorkbench() {
            return null;
        }

        public boolean isApplicationMenu(String menuId) {
            return false;
        }

        public IWorkbenchPage openPage(IAdaptable input) throws WorkbenchException {
            return null;
        }

        public IWorkbenchPage openPage(String perspectiveId, IAdaptable input) throws WorkbenchException {
            return null;
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        }

        public void setActivePage(IWorkbenchPage page) {
        }

        public void addPageListener(IPageListener listener) {
        }

        public void addPerspectiveListener(IPerspectiveListener listener) {
        }

        public void removePageListener(IPageListener listener) {
        }

        public void removePerspectiveListener(IPerspectiveListener listener) {
        }

        public Object getService(Class api) {
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    }
}

