/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.IPropertyNameProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class SWTBindingPropertyLocator
implements IBindingPropertyLocator {
    public static final String BINDING_PROPERTY = "binding_property";
    private static SWTBindingPropertyLocator locator;

    private SWTBindingPropertyLocator() {
    }

    public static SWTBindingPropertyLocator getInstance() {
        if (locator == null) {
            locator = new SWTBindingPropertyLocator();
        }
        return locator;
    }

    public String locateBindingProperty(Object uiControl) {
        if (uiControl instanceof Widget) {
            Widget widget = (Widget)uiControl;
            if (widget.isDisposed()) {
                return null;
            }
            return this.locateBindingProperty(widget);
        }
        if (uiControl instanceof IPropertyNameProvider) {
            return ((IPropertyNameProvider)uiControl).getPropertyName();
        }
        return null;
    }

    private String locateBindingProperty(Widget widget) {
        String parentProperty;
        Composite parent;
        String fullProperty = (String)widget.getData(BINDING_PROPERTY);
        if (StringUtils.isEmpty((CharSequence)fullProperty)) {
            fullProperty = "";
        }
        if (widget instanceof Control && (parent = ((Control)widget).getParent()) != null && !StringUtils.isEmpty((CharSequence)(parentProperty = this.locateBindingProperty((Widget)parent))) && parent instanceof IComplexComponent) {
            fullProperty = String.valueOf(parentProperty) + "." + fullProperty;
        }
        return fullProperty;
    }

    public void setBindingProperty(Object uiControl, String id) {
        if (uiControl instanceof Widget) {
            Widget control = (Widget)uiControl;
            if (control.isDisposed()) {
                return;
            }
            control.setData(BINDING_PROPERTY, (Object)id);
        } else if (uiControl instanceof IPropertyNameProvider) {
            ((IPropertyNameProvider)uiControl).setPropertyName(id);
        }
    }
}

