/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.publisher;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.communication.core.publisher.IServicePublishBinder;
import org.eclipse.riena.communication.core.util.CommunicationUtil;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.communication.publisher.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MultiServicePublisher {
    private String filter;
    private BundleContext context;
    private String protocol;
    private IServicePublishBinder binder;

    public MultiServicePublisher() {
        Inject.service((String)IServicePublishBinder.class.getName()).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public MultiServicePublisher useFilter(String filter) {
        Assert.isNotNull((Object)filter);
        this.filter = filter;
        return this;
    }

    public MultiServicePublisher withProtocol(String protocol) {
        Assert.isNotNull((Object)protocol);
        this.protocol = protocol;
        return this;
    }

    public void andStart(BundleContext context) {
        Assert.isNotNull((Object)this.filter);
        this.context = context;
        try {
            ServiceReference[] refs = this.context.getServiceReferences(null, this.filter);
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    this.publish(ref);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e1) {
            e1.printStackTrace();
        }
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    MultiServicePublisher.this.publish(event.getServiceReference());
                } else if (event.getType() == 4) {
                    MultiServicePublisher.this.unpublish(event.getServiceReference());
                }
            }
        };
        try {
            Activator.getDefault().getContext().addServiceListener(listener, this.filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void bind(IServicePublishBinder binder) {
        this.binder = binder;
    }

    public void unbind(IServicePublishBinder binder) {
        this.binder = null;
    }

    private void publish(ServiceReference serviceReference) {
        String usedProtocol = this.protocol != null ? this.protocol : CommunicationUtil.accessProperty((Object)serviceReference.getProperty("riena.remote.protocol"), null);
        String path = CommunicationUtil.accessProperty((Object)serviceReference.getProperty("riena.remote.path"), null);
        this.binder.publish(serviceReference, path, usedProtocol);
    }

    private void unpublish(ServiceReference serviceReference) {
        this.binder.unpublish(serviceReference);
    }
}

