/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.nls.Messages;
import org.eclipse.riena.ui.ridgets.validation.Utils;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public abstract class AbstractValidDate
implements IValidator,
IExecutableExtension {
    private static final String DAY_COMPONENT_LETTER = "d";
    private static final String MONTH_COMPONENT_LETTER = "M";
    private static final String YEAR_COMPONENT_LETTER = "y";
    private static final String A_LEAP_YEAR = "2004";
    private char separatorKey = (char)46;
    private String placeholderValid = "1";
    private String placeholderInvalid = "?";
    private String pattern;
    private boolean checkValidIntermediate;

    protected AbstractValidDate(boolean checkValidIntermediate) {
        this("", checkValidIntermediate);
    }

    public AbstractValidDate(String pattern, boolean checkValidIntermediate) {
        this.pattern = pattern;
        this.checkValidIntermediate = checkValidIntermediate;
    }

    public IStatus validate(Object value) {
        if (value != null) {
            if (!(value instanceof String)) {
                throw new ValidationFailure("ValidCharacters can only validate objects of type String.");
            }
            String string = (String)value;
            if (Utils.isEmptyDate(string)) {
                return ValidationRuleStatus.ok();
            }
            if (string.length() > 0 && !this.isDateValid(string, this.pattern)) {
                String message = NLS.bind((String)Messages.AbstractValidDate_error_invalidDate, (Object)this.pattern);
                return ValidationRuleStatus.error(false, message);
            }
        }
        return ValidationRuleStatus.ok();
    }

    private boolean isDateValid(String value, String datePattern) {
        if (datePattern.contains(DAY_COMPONENT_LETTER) && datePattern.contains(MONTH_COMPONENT_LETTER) && !datePattern.contains(YEAR_COMPONENT_LETTER)) {
            datePattern = String.valueOf(datePattern) + this.separatorKey + YEAR_COMPONENT_LETTER + YEAR_COMPONENT_LETTER + YEAR_COMPONENT_LETTER + YEAR_COMPONENT_LETTER;
            value = String.valueOf(value) + this.separatorKey + A_LEAP_YEAR;
        }
        if (this.checkValidIntermediate) {
            return this.isDate(this.complete(value, datePattern), datePattern, false);
        }
        return this.isDate(value, datePattern, true);
    }

    private boolean isDate(String value, String pattern, boolean strict) {
        if (value == null || pattern == null || pattern.length() <= 0) {
            return false;
        }
        if (strict && value.length() != pattern.length()) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(value, pos);
        if (pos.getErrorIndex() != -1) {
            return false;
        }
        return !strict || pos.getIndex() >= value.length();
    }

    private String complete(String value, String datePattern) {
        StringBuilder completedValue = new StringBuilder();
        String valueToCheck = value;
        String datePatternToCheck = datePattern;
        int nextSeparatorIndex = this.nextSeparatorIndex(datePatternToCheck);
        while (nextSeparatorIndex != -1) {
            int nextSeparatorIndexOfValueToCheck = valueToCheck.indexOf(datePatternToCheck.charAt(nextSeparatorIndex));
            if (nextSeparatorIndexOfValueToCheck == -1) break;
            if (nextSeparatorIndexOfValueToCheck == 0 || this.isPlaceholderInvalidSubstitutionNeeded(valueToCheck.substring(0, nextSeparatorIndexOfValueToCheck))) {
                completedValue.append(this.placeholderValid);
                completedValue.append(valueToCheck.charAt(nextSeparatorIndexOfValueToCheck));
            } else if (this.isNoPossibleCompletionToAllowedYear(valueToCheck.substring(0, nextSeparatorIndexOfValueToCheck), datePatternToCheck)) {
                completedValue.append(this.placeholderInvalid);
            } else {
                completedValue.append(valueToCheck.substring(0, nextSeparatorIndexOfValueToCheck + 1));
            }
            datePatternToCheck = datePatternToCheck.substring(nextSeparatorIndex + 1);
            valueToCheck = valueToCheck.substring(nextSeparatorIndexOfValueToCheck + 1);
            nextSeparatorIndex = this.nextSeparatorIndex(datePatternToCheck);
        }
        if ("".equals(valueToCheck) && !"".equals(datePatternToCheck) || this.isPlaceholderInvalidSubstitutionNeeded(valueToCheck)) {
            completedValue.append(this.placeholderValid);
        } else if (this.isNoPossibleCompletionToAllowedYear(valueToCheck, datePatternToCheck)) {
            completedValue.append(this.placeholderInvalid);
        } else {
            completedValue.append(valueToCheck);
        }
        return completedValue.toString();
    }

    private boolean isPlaceholderInvalidSubstitutionNeeded(String value) {
        return "0".equals(value);
    }

    private boolean isNoPossibleCompletionToAllowedYear(String value, String datePattern) {
        boolean result = false;
        if (datePattern.startsWith("yyyy")) {
            String trimedValue = value.trim();
            result = trimedValue.length() < 2 || trimedValue.length() > 2 && trimedValue.startsWith("0");
        }
        return result;
    }

    private int nextSeparatorIndex(String value) {
        int i = 0;
        while (i < value.length()) {
            if (!Character.isLetter(value.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setPattern(String pattern) {
        this.pattern = pattern;
    }

    protected void setCheckValidIntermediate(boolean checkValidIntermediate) {
        this.checkValidIntermediate = checkValidIntermediate;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] args = PropertiesUtils.asArray((Object)data);
            this.setPattern(args[0]);
        }
    }
}

