/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.server;

import java.security.Principal;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.hooks.IServiceHook;
import org.eclipse.riena.communication.core.hooks.ServiceContext;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.cache.IGenericObjectCache;
import org.eclipse.riena.internal.security.server.Activator;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.NotAuthorizedFailure;
import org.eclipse.riena.security.common.session.ISessionHolder;
import org.eclipse.riena.security.common.session.Session;
import org.eclipse.riena.security.server.session.ISessionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityServiceHook
implements IServiceHook {
    private static final String RIENA_SSOID = "de.compeople.ssoid";
    public static final String SESSIONID = "ssoid";
    public static final String SSOID = "x-compeople-ssoid";
    public static final String PRINCIPAL = "principal";
    public static final String SET_SESSION = "set-ssoid";
    private static final String RIENA_SECURE_WEBSERVICES_PROPERTY = "riena.secure.webservices";
    private IGenericObjectCache<String, Principal[]> principalCache;
    private ISessionService sessionService;
    private ISubjectHolder subjectHolder;
    private ISessionHolder sessionHolder;
    private boolean requiresSSOIDbyDefault = false;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SecurityServiceHook.class);

    public SecurityServiceHook() {
        String appName = "???appname??????";
        if (!this.requiresSSOIDbyDefault) {
            LOGGER.log(3, String.valueOf(appName) + ": defining ALL WEBSERVICES in this Webapp as unsecure (SSOID is not required).");
        }
    }

    public void bind(IGenericObjectCache<String, Principal[]> principalCache) {
        this.principalCache = principalCache;
    }

    public void unbind(IGenericObjectCache<String, Principal[]> principalCache) {
        if (this.principalCache == principalCache) {
            this.principalCache = null;
        }
    }

    public void bind(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void unbind(ISessionService sessionService) {
        if (this.sessionService == sessionService) {
            this.sessionService = null;
        }
    }

    public void bind(ISubjectHolder subjectHolder) {
        this.subjectHolder = subjectHolder;
    }

    public void unbind(ISubjectHolder subjectHolder) {
        if (this.subjectHolder == subjectHolder) {
            this.subjectHolder = null;
        }
    }

    public void bind(ISessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
    }

    public void unbind(ISessionHolder sessionHolder) {
        if (this.sessionHolder == sessionHolder) {
            this.sessionHolder = null;
        }
    }

    public void beforeService(ServiceContext callback) {
        boolean requiresSSOID = this.requiresSSOIDbyDefault;
        Cookie[] cookies = callback.getCookies();
        String ssoid = null;
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals(SSOID)) {
                    ssoid = cookies[i].getValue();
                }
                ++i;
            }
        }
        if (ssoid != null && ssoid.length() == 0) {
            ssoid = null;
        }
        LOGGER.log(4, "before Service ssoid = " + ssoid);
        if (ssoid == null && requiresSSOID) {
            LOGGER.log(1, "error in call to webservice {" + callback.getInterfaceName() + "} since it is not in the list of webservices that do not require a session but SSOID=null !!!");
            if (Boolean.valueOf(System.getProperty(RIENA_SECURE_WEBSERVICES_PROPERTY, Boolean.TRUE.toString())).booleanValue()) {
                throw new NotAuthorizedFailure("call to webservice " + callback.getInterfaceName() + " failed, no valid session was given but is required.");
            }
        }
        if (ssoid != null) {
            Object[] principals = (Principal[])this.principalCache.get((Object)ssoid);
            if (principals == null) {
                principals = this.sessionService.findPrincipals(new Session(ssoid));
                LOGGER.log(4, "sessionService found principal = " + Arrays.toString(principals));
                if (principals == null && requiresSSOID) {
                    LOGGER.log(1, "ssoid {" + ssoid + "} found in request but SessionService could not find a Principal.");
                    throw new NotAuthorizedFailure("call to webservice with invalid ssoid");
                }
                if (principals != null) {
                    this.principalCache.put((Object)ssoid, (Object)principals);
                }
            } else {
                LOGGER.log(4, "found principal in cache = " + Arrays.toString(principals));
            }
            if (principals != null) {
                Subject subject = new Subject();
                Object[] objectArray = principals;
                int n = principals.length;
                int n2 = 0;
                while (n2 < n) {
                    Object p = objectArray[n2];
                    subject.getPrincipals().add((Principal)p);
                    ++n2;
                }
                this.subjectHolder.setSubject(subject);
                callback.setProperty("riena.subject", (Object)subject);
            }
        }
        if (ssoid != null) {
            Session beforeSession = new Session(ssoid);
            this.sessionHolder.setSession(beforeSession);
            callback.setProperty(RIENA_SSOID, (Object)beforeSession);
        }
    }

    public void afterService(ServiceContext context) {
        Session afterSession = this.sessionHolder.getSession();
        Session beforeSession = (Session)context.getProperty(RIENA_SSOID);
        String ssoid = null;
        if (afterSession != null) {
            ssoid = afterSession.getSessionId();
        }
        if (beforeSession != null) {
            LOGGER.log(4, "afterService after_ssoid=" + ssoid + " before_ssoid=" + beforeSession.getSessionId());
        }
        LOGGER.log(4, "afterService compare session instance before=" + beforeSession + " after=" + afterSession);
        if (beforeSession != afterSession || beforeSession != null && afterSession != null && !beforeSession.getSessionId().equals(ssoid)) {
            if (ssoid == null || ssoid.equals("0")) {
                Cookie cookie = new Cookie(SSOID, "");
                cookie.setPath("/");
                context.addCookie(cookie);
                LOGGER.log(4, "setting cookie to '0'");
            } else {
                Cookie cookie = new Cookie(SSOID, ssoid);
                cookie.setPath("/");
                context.addCookie(cookie);
                if (beforeSession != null && !beforeSession.getSessionId().equals("0")) {
                    LOGGER.log(2, "CHANGING cookie setting from '" + beforeSession.getSessionId() + "' to '" + ssoid + "'");
                } else {
                    LOGGER.log(4, "setting cookie to '" + ssoid + "'");
                }
            }
        } else {
            LOGGER.log(4, "doing nothing in afterService");
        }
        this.sessionHolder.setSession(null);
        this.subjectHolder.setSubject(null);
    }
}

