/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.hooks;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.hooks.IServiceMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContext {
    private final RemoteServiceDescription rsd;
    private final Method method;
    private final Object service;
    private final IServiceMessageContext messageContext;
    private HashMap<String, Object> properties;

    public ServiceContext(RemoteServiceDescription rsd, Method method, Object service, IServiceMessageContext messageContext) {
        this.rsd = rsd;
        this.service = service;
        this.method = method;
        this.messageContext = messageContext;
    }

    public String getInterfaceName() {
        return this.rsd.getServiceInterfaceClassName();
    }

    public Class<?> getInterfaceClass() {
        return this.rsd.getServiceInterfaceClass();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getService() {
        return this.service;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public IServiceMessageContext getMessageContext() {
        return this.messageContext;
    }

    public Cookie[] getCookies() {
        List<String> cookieValues = this.messageContext.getRequestHeaderValue("Cookie");
        if (cookieValues == null || cookieValues.size() == 0) {
            return null;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String temp : cookieValues) {
            cookies.add(new Cookie(temp.substring(0, temp.indexOf("=")), temp.substring(temp.indexOf("=") + 1)));
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.messageContext.addResponseHeader("Set-Cookie", String.valueOf(cookie.getName()) + "=" + cookie.getValue());
    }
}

