/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.demo.common.Contract;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.AbstractMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class CustomerContractController
extends SubModuleController {
    public void configureRidgets() {
        Customer customer = (Customer)((ISubModuleNode)this.getNavigationNode()).getParent().getContext("demo.customer");
        ITextRidget firstName = (ITextRidget)this.getRidget("firstname");
        firstName.bindToModel((Object)customer, "firstName");
        firstName.setMandatory(true);
        ITextRidget lastName = (ITextRidget)this.getRidget("lastname");
        lastName.setMandatory(true);
        lastName.bindToModel((Object)customer, "lastName");
        IMasterDetailsRidget master = (IMasterDetailsRidget)this.getRidget("contracts");
        master.setDelegate((IMasterDetailsDelegate)new ContractDelegate());
        String[] properties = new String[]{"contractNo", "contractValue", "status"};
        String[] headers = new String[]{"contract#", "value", "status"};
        master.bindToModel((IObservableList)new WritableList(customer.getContracts(), Contract.class), Contract.class, properties, headers);
        this.updateAllRidgetsFromModel();
        ((ISubModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new SubModuleNodeListener(){

            public void activated(ISubModuleNode source) {
                CustomerContractController.this.updateAllRidgetsFromModel();
            }
        });
    }

    public static final class ContractDelegate
    extends AbstractMasterDetailsDelegate {
        private final Contract workingCopy = this.createWorkingCopy();

        public void configureRidgets(IRidgetContainer container) {
            ITextRidget txtcontractNo = (ITextRidget)container.getRidget("contractno");
            txtcontractNo.setMandatory(true);
            txtcontractNo.bindToModel((Object)this.workingCopy, "contractNo");
            txtcontractNo.updateFromModel();
            ITextRidget txtLast = (ITextRidget)container.getRidget("description");
            txtLast.bindToModel((Object)this.workingCopy, "description");
            txtLast.updateFromModel();
            ITextRidget txtValue = (ITextRidget)container.getRidget("value");
            txtValue.setMandatory(true);
            txtValue.bindToModel((Object)this.workingCopy, "contractValue");
            txtValue.updateFromModel();
            ITextRidget txtStatus = (ITextRidget)container.getRidget("status");
            txtStatus.bindToModel((Object)this.workingCopy, "status");
            txtStatus.updateFromModel();
        }

        public Contract createWorkingCopy() {
            return new Contract();
        }

        public Contract copyBean(Object source, Object target) {
            Contract from = source != null ? (Contract)source : this.createWorkingCopy();
            Contract to = target != null ? (Contract)target : this.createWorkingCopy();
            to.setContractNo(from.getContractNo());
            to.setDescription(from.getDescription());
            to.setContractValue(from.getContractValue());
            to.setStatus(from.getStatus());
            return to;
        }

        public Object getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isChanged(Object source, Object target) {
            Contract source2 = (Contract)source;
            Contract target2 = (Contract)target;
            return !source2.getContractNo().equals(target2.getContractNo()) || source2.getContractValue() != target2.getContractValue() || !source2.getDescription().equals(target2.getDescription()) || !source2.getStatus().equals(target2.getStatus());
        }
    }
}

