/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterProvider;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class CustomerOverviewController
extends SubModuleController {
    private IUIFilter assistent = ((IUIFilterProvider)Service.get(IUIFilterProvider.class)).provideFilter("demo.assistent").getFilter();
    private IUIFilter mandatory = ((IUIFilterProvider)Service.get(IUIFilterProvider.class)).provideFilter("demo.mandatory").getFilter();
    private Customer customer;

    public void configureRidgets() {
        this.customer = (Customer)((ISubModuleNode)this.getNavigationNode()).getParent().getContext("demo.customer");
        if (this.customer == null) {
            NavigationArgument navigationArgument = ((ISubModuleNode)this.getNavigationNode()).getNavigationArgument();
            if (navigationArgument != null) {
                this.customer = (Customer)navigationArgument.getParameter();
            } else {
                this.customer = new Customer();
                ((ISubModuleNode)this.getNavigationNode()).getParent().setLabel("new Customer");
            }
            ((ISubModuleNode)this.getNavigationNode()).getParent().setContext("demo.customer", (Object)this.customer);
        }
        ITextRidget firstName = (ITextRidget)this.getRidget("firstname");
        firstName.bindToModel((Object)this.customer, "firstName");
        firstName.setMandatory(true);
        ITextRidget lastName = (ITextRidget)this.getRidget("lastname");
        lastName.setMandatory(true);
        lastName.bindToModel((Object)this.customer, "lastName");
        ((ITextRidget)this.getRidget("zipcode")).bindToModel((Object)this.customer.getAddress(), "zipCode");
        ((ITextRidget)this.getRidget("street")).bindToModel((Object)this.customer.getAddress(), "street");
        ((ITextRidget)this.getRidget("city")).bindToModel((Object)this.customer.getAddress(), "city");
        ((ITextRidget)this.getRidget("emailaddress")).bindToModel((Object)this.customer, "emailAddress");
        ((IDateTextRidget)this.getRidget("birthdate")).bindToModel((Object)this.customer, "birthDate");
        ((ITextRidget)this.getRidget("salary")).bindToModel((Object)this.customer, "salary");
        ((IDecimalTextRidget)this.getRidget("salary")).setPrecision(2);
        this.updateAllRidgetsFromModel();
        ((IActionRidget)this.getRidget("openEmailsAction")).addListener(new IActionListener(){

            public void callback() {
                String emailAddress = CustomerOverviewController.this.customer.getEmailAddress();
                ((ISubModuleNode)CustomerOverviewController.this.getNavigationNode()).jump(new NavigationNodeId("riena.demo.client.customermailfolders.mails", emailAddress), new NavigationArgument((Object)CustomerOverviewController.this.customer));
            }
        });
        ((IActionRidget)this.getRidget("assistent")).addListener(new IActionListener(){

            public void callback() {
                IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)CustomerOverviewController.this.getNavigationNode()).getParentOfType(IApplicationNode.class);
                if (((IToggleButtonRidget)CustomerOverviewController.this.getRidget("assistent")).isSelected()) {
                    applNode.addFilter(CustomerOverviewController.this.assistent);
                } else {
                    applNode.removeFilter(CustomerOverviewController.this.assistent);
                }
            }
        });
        ((IActionRidget)this.getRidget("mandatory")).addListener(new IActionListener(){

            public void callback() {
                IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)CustomerOverviewController.this.getNavigationNode()).getParentOfType(IApplicationNode.class);
                if (((IToggleButtonRidget)CustomerOverviewController.this.getRidget("mandatory")).isSelected()) {
                    applNode.addFilter(CustomerOverviewController.this.mandatory);
                } else {
                    applNode.removeFilter(CustomerOverviewController.this.mandatory);
                }
            }
        });
        ((ISubModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new SubModuleNodeListener(){

            public void activated(ISubModuleNode source) {
                CustomerOverviewController.this.updateAllRidgetsFromModel();
            }
        });
    }
}

