/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.exceptionhandler;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.exception.IExceptionHandler;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ExceptionMessageBox
implements IExceptionHandler {
    public IExceptionHandler.Action handleException(Throwable t, String msg, Logger logger) {
        MessageBox messageBox = new MessageBox((Composite)Display.getCurrent().getActiveShell());
        IMessageBoxRidget messageBoxRidget = (IMessageBoxRidget)SwtRidgetFactory.createRidget((Object)messageBox);
        messageBoxRidget.setTitle("Exception at Runtime");
        messageBoxRidget.setType(IMessageBoxRidget.Type.ERROR);
        if (t != null) {
            messageBoxRidget.setText(t.getMessage());
        }
        IMessageBoxRidget.MessageBoxOption ok = new IMessageBoxRidget.MessageBoxOption("OK");
        IMessageBoxRidget.MessageBoxOption ignore = new IMessageBoxRidget.MessageBoxOption("Ignore");
        IMessageBoxRidget.MessageBoxOption printstack = new IMessageBoxRidget.MessageBoxOption("Print stacktrace and OK");
        messageBoxRidget.setOptions(new IMessageBoxRidget.MessageBoxOption[]{ok, ignore, printstack});
        IMessageBoxRidget.MessageBoxOption show = messageBoxRidget.show();
        if (t != null && show.equals(printstack)) {
            t.printStackTrace();
        }
        if (show.equals(ignore)) {
            return IExceptionHandler.Action.NOT_HANDLED;
        }
        return IExceptionHandler.Action.OK;
    }

    public IExceptionHandler.Action handleUncaught(Throwable t, String msg, Logger logger) {
        return IExceptionHandler.Action.NOT_HANDLED;
    }
}

