/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.navigation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.example.client.controllers.DemoTargetSubModuleController;
import org.eclipse.riena.example.client.views.DemoTargetSubModuleView;
import org.eclipse.riena.navigation.AbstractNavigationAssembler;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoTargetNodeAssembler
extends AbstractNavigationAssembler {
    public static final String ID = "org.eclipse.riena.example.navigate.demotarget";
    private Set<String> knownTargetIds = null;

    public boolean acceptsToBuildNode(NavigationNodeId nodeId, NavigationArgument argument) {
        if (this.knownTargetIds == null) {
            this.knownTargetIds = new HashSet<String>(Arrays.asList(ID));
            this.knownTargetIds = Collections.unmodifiableSet(this.knownTargetIds);
        }
        return this.knownTargetIds.contains(nodeId.getTypeId());
    }

    public INavigationNode<?>[] buildNode(NavigationNodeId nodeId, NavigationArgument navigationArgument) {
        ModuleGroupNode moduleGroup = new ModuleGroupNode(new NavigationNodeId("org.eclipse.riena.example.navigate.target.moduleGroup"));
        moduleGroup.setPresentWithSingleModule(false);
        ModuleNode module = new ModuleNode(new NavigationNodeId(ID), "Target Module");
        module.setIcon("ledlightgreen.png");
        moduleGroup.addChild((INavigationNode)module);
        SubModuleNode subModule = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.example.navigate.target.submodule"), "Target");
        IWorkareaDefinition def = WorkareaManager.getInstance().registerDefinition((INavigationNode)subModule, DemoTargetSubModuleController.class, (Object)DemoTargetSubModuleView.ID);
        def.setRequiredPreparation(true);
        module.addChild((INavigationNode)subModule);
        return new INavigationNode[]{moduleGroup};
    }
}

