/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.extension.IModuleGroupNode2Extension;
import org.eclipse.riena.navigation.extension.IModuleNode2Extension;
import org.eclipse.riena.navigation.extension.INode2Extension;
import org.eclipse.riena.navigation.extension.ISubApplicationNode2Extension;
import org.eclipse.riena.navigation.extension.ISubModuleNode2Extension;
import org.eclipse.riena.navigation.extension.ModuleGroupNode2Extension;
import org.eclipse.riena.navigation.extension.ModuleNode2Extension;
import org.eclipse.riena.navigation.extension.SubApplicationNode2Extension;
import org.eclipse.riena.navigation.extension.SubModuleNode2Extension;
import org.eclipse.riena.navigation.model.GenericNavigationAssembler;

@NonUITestCase
public class GenericNavigationAssemblerTest
extends TestCase {
    public void testCreateNavigationNodeIdFromTemplate() {
        MyGenericNavigationAssembler assembler = new MyGenericNavigationAssembler();
        NavigationNodeId template = new NavigationNodeId("type1", "inst1");
        ModuleNode2Extension extension = new ModuleNode2Extension();
        extension.setNodeId("type2");
        NavigationNodeId createdId = assembler.createNavigationNodeIdFromTemplate(template, (INode2Extension)extension, null);
        GenericNavigationAssemblerTest.assertEquals((String)"type2", (String)createdId.getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)createdId.getInstanceId());
    }

    public void testBuildISubModuleNode2Extension() {
        MyGenericNavigationAssembler assembler = new MyGenericNavigationAssembler();
        NavigationNodeId targetId = new NavigationNodeId("type1", "inst1");
        SubModuleNode2Extension extension1 = new SubModuleNode2Extension();
        extension1.setNodeId("type2");
        extension1.setName("sub1");
        extension1.setSelectable(false);
        extension1.setIcon("icon1");
        SubModuleNode2Extension extension2 = new SubModuleNode2Extension();
        extension2.setNodeId("type22");
        extension2.setName("sub2");
        extension2.setSelectable(true);
        extension2.setIcon("icon2");
        extension1.setChildNodes((INode2Extension[])new ISubModuleNode2Extension[]{extension2});
        HashMap<String, Object> context = new HashMap<String, Object>();
        ISubModuleNode sm1 = assembler.build((ISubModuleNode2Extension)extension1, targetId, null, context);
        GenericNavigationAssemblerTest.assertEquals((String)"sub1", (String)sm1.getLabel());
        GenericNavigationAssemblerTest.assertFalse((boolean)sm1.isSelectable());
        GenericNavigationAssemblerTest.assertEquals((String)"icon1", (String)sm1.getIcon());
        GenericNavigationAssemblerTest.assertEquals((String)"type2", (String)sm1.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)sm1.getNodeId().getInstanceId());
        GenericNavigationAssemblerTest.assertEquals((int)1, (int)sm1.getChildren().size());
        ISubModuleNode sm2 = (ISubModuleNode)sm1.getChild(0);
        GenericNavigationAssemblerTest.assertEquals((String)"sub2", (String)sm2.getLabel());
        GenericNavigationAssemblerTest.assertTrue((boolean)sm2.isSelectable());
        GenericNavigationAssemblerTest.assertEquals((String)"icon2", (String)sm2.getIcon());
        GenericNavigationAssemblerTest.assertEquals((String)"type22", (String)sm2.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)sm2.getNodeId().getInstanceId());
    }

    public void testBuildIModuleNode2Extension() {
        MyGenericNavigationAssembler assembler = new MyGenericNavigationAssembler();
        NavigationNodeId targetId = new NavigationNodeId("type1", "inst1");
        ModuleNode2Extension extension1 = new ModuleNode2Extension();
        extension1.setNodeId("type2");
        extension1.setName("m1");
        extension1.setIcon("icon1");
        SubModuleNode2Extension subExtension1 = new SubModuleNode2Extension();
        subExtension1.setNodeId("type12");
        subExtension1.setName("sub1");
        SubModuleNode2Extension subExtension2 = new SubModuleNode2Extension();
        subExtension2.setNodeId("type22");
        subExtension2.setName("sub2");
        extension1.setChildNodes((INode2Extension[])new ISubModuleNode2Extension[]{subExtension1, subExtension2});
        HashMap<String, Object> context = new HashMap<String, Object>();
        IModuleNode m1 = assembler.build((IModuleNode2Extension)extension1, targetId, null, context);
        GenericNavigationAssemblerTest.assertEquals((String)"m1", (String)m1.getLabel());
        GenericNavigationAssemblerTest.assertEquals((String)"icon1", (String)m1.getIcon());
        GenericNavigationAssemblerTest.assertEquals((String)"type2", (String)m1.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)m1.getNodeId().getInstanceId());
        GenericNavigationAssemblerTest.assertEquals((int)2, (int)m1.getChildren().size());
        ISubModuleNode sm1 = (ISubModuleNode)m1.getChild(0);
        GenericNavigationAssemblerTest.assertEquals((String)"sub1", (String)sm1.getLabel());
        GenericNavigationAssemblerTest.assertEquals((String)"type12", (String)sm1.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)sm1.getNodeId().getInstanceId());
        ISubModuleNode sm2 = (ISubModuleNode)m1.getChild(1);
        GenericNavigationAssemblerTest.assertEquals((String)"sub2", (String)sm2.getLabel());
        GenericNavigationAssemblerTest.assertEquals((String)"type22", (String)sm2.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)sm2.getNodeId().getInstanceId());
    }

    public void testBuildIModuleGroupNode2Extension() {
        MyGenericNavigationAssembler assembler = new MyGenericNavigationAssembler();
        NavigationNodeId targetId = new NavigationNodeId("type1", "inst1");
        ModuleGroupNode2Extension extension1 = new ModuleGroupNode2Extension();
        extension1.setNodeId("type2");
        extension1.setName("mg1");
        extension1.setIcon("icon1");
        ModuleNode2Extension mExtension1 = new ModuleNode2Extension();
        mExtension1.setNodeId("type22");
        mExtension1.setName("m2");
        mExtension1.setIcon("icon2");
        extension1.setChildNodes((INode2Extension[])new IModuleNode2Extension[]{mExtension1});
        HashMap<String, Object> context = new HashMap<String, Object>();
        IModuleGroupNode mg1 = assembler.build((IModuleGroupNode2Extension)extension1, targetId, null, context);
        GenericNavigationAssemblerTest.assertEquals((String)"mg1", (String)mg1.getLabel());
        GenericNavigationAssemblerTest.assertEquals((String)"icon1", (String)mg1.getIcon());
        GenericNavigationAssemblerTest.assertEquals((String)"type2", (String)mg1.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)mg1.getNodeId().getInstanceId());
        GenericNavigationAssemblerTest.assertEquals((int)1, (int)mg1.getChildren().size());
        IModuleNode m1 = (IModuleNode)mg1.getChild(0);
        GenericNavigationAssemblerTest.assertEquals((String)"m2", (String)m1.getLabel());
        GenericNavigationAssemblerTest.assertEquals((String)"icon2", (String)m1.getIcon());
        GenericNavigationAssemblerTest.assertEquals((String)"type22", (String)m1.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)m1.getNodeId().getInstanceId());
    }

    public void testBuildISubApplicationNode2Extension() {
        MyGenericNavigationAssembler assembler = new MyGenericNavigationAssembler();
        NavigationNodeId targetId = new NavigationNodeId("type1", "inst1");
        SubApplicationNode2Extension extension1 = new SubApplicationNode2Extension();
        extension1.setNodeId("type2");
        extension1.setName("sa1");
        extension1.setIcon("icon1");
        extension1.setPerspectiveId("p1");
        ModuleGroupNode2Extension mgExtension1 = new ModuleGroupNode2Extension();
        mgExtension1.setNodeId("type22");
        mgExtension1.setName("mg2");
        mgExtension1.setIcon("icon2");
        extension1.setChildNodes((INode2Extension[])new IModuleGroupNode2Extension[]{mgExtension1});
        HashMap<String, Object> context = new HashMap<String, Object>();
        ISubApplicationNode sa1 = assembler.build((ISubApplicationNode2Extension)extension1, targetId, null, context);
        GenericNavigationAssemblerTest.assertEquals((String)"sa1", (String)sa1.getLabel());
        GenericNavigationAssemblerTest.assertEquals((String)"icon1", (String)sa1.getIcon());
        GenericNavigationAssemblerTest.assertEquals((String)"type2", (String)sa1.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)sa1.getNodeId().getInstanceId());
        GenericNavigationAssemblerTest.assertEquals((int)1, (int)sa1.getChildren().size());
        IModuleGroupNode mg1 = (IModuleGroupNode)sa1.getChild(0);
        GenericNavigationAssemblerTest.assertEquals((String)"mg2", (String)mg1.getLabel());
        GenericNavigationAssemblerTest.assertEquals((String)"icon2", (String)mg1.getIcon());
        GenericNavigationAssemblerTest.assertEquals((String)"type22", (String)mg1.getNodeId().getTypeId());
        GenericNavigationAssemblerTest.assertEquals((String)"inst1", (String)mg1.getNodeId().getInstanceId());
    }

    public void testResolveTargetIds() {
        MyGenericNavigationAssembler assembler = new MyGenericNavigationAssembler();
        SubApplicationNode2Extension extension1 = new SubApplicationNode2Extension();
        extension1.setNodeId("sa1");
        ModuleGroupNode2Extension extension2 = new ModuleGroupNode2Extension();
        extension2.setNodeId("mg1");
        extension1.setChildNodes((INode2Extension[])new IModuleGroupNode2Extension[]{extension2});
        ModuleNode2Extension extension3 = new ModuleNode2Extension();
        extension3.setNodeId("m1");
        extension2.setChildNodes((INode2Extension[])new IModuleNode2Extension[]{extension3});
        SubModuleNode2Extension extension4 = new SubModuleNode2Extension();
        extension4.setNodeId("sub1");
        extension3.setChildNodes((INode2Extension[])new ISubModuleNode2Extension[]{extension4});
        SubModuleNode2Extension extension5 = new SubModuleNode2Extension();
        extension5.setNodeId("sub11");
        SubModuleNode2Extension extension6 = new SubModuleNode2Extension();
        extension6.setNodeId("sub12");
        extension4.setChildNodes((INode2Extension[])new ISubModuleNode2Extension[]{extension5, extension6});
        ReflectionUtils.invokeHidden((Object)((Object)assembler), (String)"resolveTargetIds", (Object[])new Object[]{extension1});
        GenericNavigationAssemblerTest.assertTrue((boolean)assembler.acceptedTargetIdsContains("sa1"));
        GenericNavigationAssemblerTest.assertTrue((boolean)assembler.acceptedTargetIdsContains("mg1"));
        GenericNavigationAssemblerTest.assertTrue((boolean)assembler.acceptedTargetIdsContains("m1"));
        GenericNavigationAssemblerTest.assertTrue((boolean)assembler.acceptedTargetIdsContains("sub11"));
        GenericNavigationAssemblerTest.assertTrue((boolean)assembler.acceptedTargetIdsContains("sub11"));
        GenericNavigationAssemblerTest.assertTrue((boolean)assembler.acceptedTargetIdsContains("sub12"));
        GenericNavigationAssemblerTest.assertFalse((boolean)assembler.acceptedTargetIdsContains("dummy"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyGenericNavigationAssembler
    extends GenericNavigationAssembler {
        public MyGenericNavigationAssembler() {
            this.acceptedTargetIds = new HashSet();
        }

        public void updateAcceptedTargetIds(String typeId) {
            if (typeId != null) {
                this.acceptedTargetIds.add(typeId);
            }
        }

        public boolean acceptedTargetIdsContains(String typeId) {
            return this.acceptedTargetIds.contains(typeId);
        }

        public NavigationNodeId createNavigationNodeIdFromTemplate(NavigationNodeId template, INode2Extension nodeExtension, NavigationArgument navigationArgument) {
            return super.createNavigationNodeIdFromTemplate(template, nodeExtension, navigationArgument);
        }

        public IModuleNode build(IModuleNode2Extension moduleDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
            return super.build(moduleDefinition, targetId, navigationArgument, context);
        }

        public IModuleGroupNode build(IModuleGroupNode2Extension groupDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
            return super.build(groupDefinition, targetId, navigationArgument, context);
        }

        public ISubApplicationNode build(ISubApplicationNode2Extension subApplicationDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
            return super.build(subApplicationDefinition, targetId, navigationArgument, context);
        }

        public ISubModuleNode build(ISubModuleNode2Extension subModuleDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
            return super.build(subModuleDefinition, targetId, navigationArgument, context);
        }
    }
}

