/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.binding;

import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToggleButtonRidget;
import org.eclipse.riena.navigation.IAction;
import org.eclipse.riena.ui.ridgets.ClassRidgetMapper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IMappingCondition;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class SwtControlRidgetMapperTest
extends RienaTestCase {
    private SwtControlRidgetMapper mapper;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.mapper = SwtControlRidgetMapper.getInstance();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        ReflectionUtils.setHidden(SwtControlRidgetMapper.class, (String)"instance", (Object)ReflectionUtils.newInstanceHidden(SwtControlRidgetMapper.class, (Object[])new Object[0]));
        this.mapper = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testAddMapping() throws Exception {
        this.mapper.addMapping(MockComposite.class, MockRidget.class);
        Class ridget = this.mapper.getRidgetClass(MockComposite.class);
        SwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        SwtControlRidgetMapperTest.assertEquals((String)MockRidget.class.getName(), (String)ridget.getName());
    }

    public void testAddMappingSwtStyle() throws Exception {
        this.mapper.addMapping(MockComposite.class, MockRidget.class);
        this.mapper.addMapping(MockComposite.class, MockRidget2.class, 2048);
        Class ridget = this.mapper.getRidgetClass(MockComposite.class);
        SwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        SwtControlRidgetMapperTest.assertEquals((String)MockRidget.class.getName(), (String)ridget.getName());
        MockComposite widget = new MockComposite((Composite)this.shell, 2048);
        ridget = this.mapper.getRidgetClass((Object)widget);
        SwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        SwtControlRidgetMapperTest.assertEquals((String)MockRidget2.class.getName(), (String)ridget.getName());
        widget.dispose();
    }

    public void testAddMappingWithCondition() {
        FTMappingCondition condition1 = new FTMappingCondition(false);
        FTMappingCondition condition2 = new FTMappingCondition(false);
        this.mapper.addMapping(MockComposite.class, MockRidget.class, (IMappingCondition)condition1);
        this.mapper.addMapping(MockComposite.class, MockRidget2.class, (IMappingCondition)condition2);
        MockComposite widget = new MockComposite((Composite)this.shell, 0);
        try {
            condition1.setMatch(true);
            Class ridgetClass = this.mapper.getRidgetClass((Object)widget);
            SwtControlRidgetMapperTest.assertNotNull((Object)ridgetClass);
            SwtControlRidgetMapperTest.assertEquals((String)MockRidget.class.getName(), (String)ridgetClass.getName());
            condition1.setMatch(false);
            condition2.setMatch(true);
            ridgetClass = this.mapper.getRidgetClass((Object)widget);
            SwtControlRidgetMapperTest.assertNotNull((Object)ridgetClass);
            SwtControlRidgetMapperTest.assertEquals((String)MockRidget2.class.getName(), (String)ridgetClass.getName());
            condition2.setMatch(false);
            try {
                this.mapper.getRidgetClass((Object)widget);
                SwtControlRidgetMapperTest.fail();
            }
            catch (BindingException bindingException) {
                this.ok();
            }
        }
        finally {
            widget.dispose();
        }
    }

    public void testGetRidgetClass() throws Exception {
        Class ridget = this.mapper.getRidgetClass(Label.class);
        SwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        SwtControlRidgetMapperTest.assertEquals((String)LabelRidget.class.getName(), (String)ridget.getName());
        try {
            this.mapper.getRidgetClass(MockComposite.class);
            SwtControlRidgetMapperTest.fail((String)"BindingException expected");
        }
        catch (BindingException bindingException) {
            this.ok("BindingException expected");
        }
    }

    public void testGetRidgetClassWidget() throws Exception {
        Button button = new Button((Composite)this.shell, -1);
        Class ridget = this.mapper.getRidgetClass((Object)button);
        SwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        SwtControlRidgetMapperTest.assertEquals((String)ActionRidget.class.getName(), (String)ridget.getName());
        button = new Button((Composite)this.shell, 0x800000);
        ridget = this.mapper.getRidgetClass((Object)button);
        SwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        SwtControlRidgetMapperTest.assertEquals((String)ActionRidget.class.getName(), (String)ridget.getName());
        button = new Button((Composite)this.shell, 32);
        ridget = this.mapper.getRidgetClass((Object)button);
        SwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        SwtControlRidgetMapperTest.assertEquals((String)ToggleButtonRidget.class.getName(), (String)ridget.getName());
    }

    public void testIsMatching() throws Exception {
        SwtControlRidgetMapper.Mapping mapping = new SwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class);
        SwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching(MockComposite.class));
        SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite2.class));
        mapping = new SwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, 32);
        SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite.class));
        SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite2.class));
        mapping = new SwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, (IMappingCondition)new FTMappingCondition(true));
        SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite.class));
        SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite2.class));
    }

    public void testIsMatchingWidget() throws Exception {
        SwtControlRidgetMapper.Mapping mapping = new SwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class);
        MockComposite comp = new MockComposite((Composite)this.shell, -1);
        SwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        MockComposite2 comp2 = new MockComposite2((Composite)this.shell, -1);
        SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching((Object)comp2));
        comp2.dispose();
        mapping = new SwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, 512);
        comp = new MockComposite((Composite)this.shell, 4);
        SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        comp = new MockComposite((Composite)this.shell, 512);
        SwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        comp = new MockComposite((Composite)this.shell, 66048);
        SwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        FTMappingCondition condition = new FTMappingCondition(true);
        mapping = new SwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, (IMappingCondition)condition);
        comp = new MockComposite((Composite)this.shell, -1);
        try {
            SwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
            condition.setMatch(false);
            SwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching((Object)comp));
        }
        finally {
            comp.dispose();
        }
    }

    public void testGetPrimaryRidgetInterface() {
        SwtControlRidgetMapperTest.assertEquals(IRidget.class, (Object)this.mapper.getPrimaryRidgetInterface(MockRidget.class));
        SwtControlRidgetMapperTest.assertEquals(IMockRidget2.class, (Object)this.mapper.getPrimaryRidgetInterface(MockRidget3.class));
        SwtControlRidgetMapperTest.assertEquals(IMockRidget2.class, (Object)this.mapper.getPrimaryRidgetInterface(MockRidgetImplementigSeveralInterfaces.class));
    }

    public void testAddMappingToClassRidgetMapper() {
        ClassRidgetMapper classRidgetMapper = ClassRidgetMapper.getInstance();
        this.mapper.addMapping(MockComposite.class, MockRidget.class);
        SwtControlRidgetMapperTest.assertEquals(MockRidget.class, (Object)classRidgetMapper.getRidgetClass(IRidget.class));
        this.mapper.addMapping(MockComposite2.class, MockRidget3.class);
        SwtControlRidgetMapperTest.assertEquals(MockRidget3.class, (Object)classRidgetMapper.getRidgetClass(IMockRidget2.class));
        try {
            classRidgetMapper.getRidgetClass(IMockRidget.class);
            SwtControlRidgetMapperTest.fail((String)"BindingException expected");
        }
        catch (BindingException bindingException) {
            this.ok("BindingException expected");
        }
    }

    private static abstract class AbstractMockRidget
    implements IMockRidget2 {
        private AbstractMockRidget() {
        }

        public Object getUIControl() {
            return null;
        }

        public void setUIControl(Object uiControl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean enabled) {
        }

        public void addFocusListener(IFocusListener listener) {
        }

        public void removeFocusListener(IFocusListener listener) {
        }

        public void updateFromModel() {
        }

        public void requestFocus() {
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isFocusable() {
            return false;
        }

        public void setFocusable(boolean focusable) {
        }

        public String getToolTipText() {
            return null;
        }

        public void setToolTipText(String toolTipText) {
        }

        public boolean isBlocked() {
            return false;
        }

        public void setBlocked(boolean blocked) {
        }

        public String getID() {
            return null;
        }
    }

    private static final class FTMappingCondition
    implements IMappingCondition {
        private boolean isMatch = true;

        public FTMappingCondition(boolean isMatch) {
            this.isMatch = isMatch;
        }

        void setMatch(boolean isMatch) {
            this.isMatch = isMatch;
        }

        public boolean isMatch(Object widget) {
            return this.isMatch;
        }
    }

    static interface IMockRidget
    extends IRidget {
    }

    static interface IMockRidget2
    extends IMockRidget {
    }

    private static final class MockComposite
    extends Composite {
        public MockComposite(Composite parent, int style) {
            super(parent, style);
        }
    }

    private static final class MockComposite2
    extends Composite {
        public MockComposite2(Composite parent, int style) {
            super(parent, style);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockNonRidgetSuperClass
    implements Comparable<MockNonRidgetSuperClass> {
        private MockNonRidgetSuperClass() {
        }

        @Override
        public int compareTo(MockNonRidgetSuperClass o) {
            return 0;
        }
    }

    private static final class MockRidget
    implements IRidget {
        private MockRidget() {
        }

        public Object getUIControl() {
            return null;
        }

        public void setUIControl(Object uiControl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean enabled) {
        }

        public void addFocusListener(IFocusListener listener) {
        }

        public void removeFocusListener(IFocusListener listener) {
        }

        public void updateFromModel() {
        }

        public void requestFocus() {
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isFocusable() {
            return false;
        }

        public void setFocusable(boolean focusable) {
        }

        public String getToolTipText() {
            return null;
        }

        public void setToolTipText(String toolTipText) {
        }

        public boolean isBlocked() {
            return false;
        }

        public void setBlocked(boolean blocked) {
        }

        public String getID() {
            return null;
        }
    }

    private static final class MockRidget2
    implements IRidget {
        private MockRidget2() {
        }

        public Object getUIControl() {
            return null;
        }

        public void setUIControl(Object uiControl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean enabled) {
        }

        public void addFocusListener(IFocusListener listener) {
        }

        public void removeFocusListener(IFocusListener listener) {
        }

        public void updateFromModel() {
        }

        public void requestFocus() {
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isFocusable() {
            return false;
        }

        public void setFocusable(boolean focusable) {
        }

        public String getToolTipText() {
            return null;
        }

        public void setToolTipText(String toolTipText) {
        }

        public boolean isBlocked() {
            return false;
        }

        public void setBlocked(boolean blocked) {
        }

        public String getID() {
            return null;
        }
    }

    private static class MockRidget3
    extends AbstractMockRidget {
        private MockRidget3() {
        }
    }

    private static class MockRidgetImplementigSeveralInterfaces
    extends MockNonRidgetSuperClass
    implements IMockRidget2,
    IAction {
        private MockRidgetImplementigSeveralInterfaces() {
        }

        public Object getUIControl() {
            return null;
        }

        public void setUIControl(Object uiControl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean enabled) {
        }

        public void addFocusListener(IFocusListener listener) {
        }

        public void removeFocusListener(IFocusListener listener) {
        }

        public void updateFromModel() {
        }

        public void requestFocus() {
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isFocusable() {
            return false;
        }

        public void setFocusable(boolean focusable) {
        }

        public String getToolTipText() {
            return null;
        }

        public void setToolTipText(String toolTipText) {
        }

        public boolean isBlocked() {
            return false;
        }

        public void setBlocked(boolean blocked) {
        }

        public String getID() {
            return null;
        }

        public void run() {
        }
    }
}

