/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public class SWTModuleControllerTest
extends TestCase {
    private SWTModuleController controller;
    private IModuleNode moduleNode;

    protected void setUp() throws Exception {
        super.setUp();
        this.moduleNode = new ModuleNode();
        this.controller = new SWTModuleController(this.moduleNode);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.moduleNode.dispose();
        this.moduleNode = null;
        this.controller = null;
    }

    public void testCollapseSibling() {
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("sm1"));
        this.moduleNode.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        this.moduleNode.addChild((INavigationNode)sm2);
        SubModuleNode sm3 = new SubModuleNode(new NavigationNodeId("sm3"));
        this.moduleNode.addChild((INavigationNode)sm3);
        SubModuleNode sm11 = new SubModuleNode(new NavigationNodeId("sm11"));
        sm1.addChild((INavigationNode)sm11);
        SubModuleNode sm12 = new SubModuleNode(new NavigationNodeId("sm12"));
        sm1.addChild((INavigationNode)sm12);
        SubModuleNode sm21 = new SubModuleNode(new NavigationNodeId("sm21"));
        sm2.addChild((INavigationNode)sm21);
        SubModuleNode sm22 = new SubModuleNode(new NavigationNodeId("sm22"));
        sm2.addChild((INavigationNode)sm22);
        SubModuleNode sm31 = new SubModuleNode(new NavigationNodeId("sm31"));
        sm3.addChild((INavigationNode)sm31);
        SubModuleNode sm32 = new SubModuleNode(new NavigationNodeId("sm32"));
        sm3.addChild((INavigationNode)sm32);
        SubModuleNode sm111 = new SubModuleNode(new NavigationNodeId("sm111"));
        sm11.addChild((INavigationNode)sm111);
        SubModuleNode sm121 = new SubModuleNode(new NavigationNodeId("sm121"));
        sm12.addChild((INavigationNode)sm121);
        SubModuleNode sm211 = new SubModuleNode(new NavigationNodeId("sm211"));
        sm21.addChild((INavigationNode)sm211);
        SubModuleNode sm221 = new SubModuleNode(new NavigationNodeId("sm221"));
        sm22.addChild((INavigationNode)sm221);
        SubModuleNode sm311 = new SubModuleNode(new NavigationNodeId("sm311"));
        sm31.addChild((INavigationNode)sm311);
        SubModuleNode sm321 = new SubModuleNode(new NavigationNodeId("sm321"));
        sm32.addChild((INavigationNode)sm321);
        this.expandAll((INavigationNode<?>)this.moduleNode, true);
        ReflectionUtils.invokeHidden((Object)this.controller, (String)"collapseSibling", (Object[])new Object[]{sm211});
        SWTModuleControllerTest.assertFalse((boolean)sm1.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm2.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm3.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm21.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm211.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm22.isExpanded());
        this.expandAll((INavigationNode<?>)this.moduleNode, true);
        ReflectionUtils.invokeHidden((Object)this.controller, (String)"collapseSibling", (Object[])new Object[]{sm32});
        SWTModuleControllerTest.assertFalse((boolean)sm1.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm2.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm3.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm31.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm32.isExpanded());
    }

    private void expandAll(INavigationNode<?> node, boolean expanded) {
        node.setExpanded(expanded);
        for (INavigationNode child : node.getChildren()) {
            this.expandAll(child, expanded);
        }
    }
}

