/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class SubModuleViewTest
extends RienaTestCase {
    private SubModuleView subModuleNodeView;
    private SubModuleNode node;
    private SubModuleNode anotherNode;
    private SubModuleNode anotherNodeSameView;
    private List<SubModuleNode> nodesBoundToView;

    protected void setUp() throws Exception {
        super.setUp();
        this.addPluginXml(SubModuleViewTest.class, "SubModuleViewTest.xml");
        ApplicationNode appNode = new ApplicationNode();
        SubApplicationNode subAppNode = new SubApplicationNode();
        appNode.addChild((INavigationNode)subAppNode);
        ModuleGroupNode mgNode = new ModuleGroupNode(null);
        subAppNode.addChild((INavigationNode)mgNode);
        ModuleNode parent = new ModuleNode(null, "TestModuleLabel");
        mgNode.addChild((INavigationNode)parent);
        this.anotherNode = new SubModuleNode(new NavigationNodeId("testId2", "2"), "TestSubModuleLabel2");
        parent.addChild((INavigationNode)this.anotherNode);
        this.anotherNodeSameView = new SubModuleNode(new NavigationNodeId("testId", "1"), "TestSubModuleLabel3");
        parent.addChild((INavigationNode)this.anotherNodeSameView);
        this.nodesBoundToView = new ArrayList<SubModuleNode>();
        this.subModuleNodeView = new TestView();
        this.node = new SubModuleNode(new NavigationNodeId("testId", "0"), "TestSubModuleLabel");
        parent.setNavigationNodeController((INavigationNodeController)new ModuleController((IModuleNode)parent));
        parent.addChild((INavigationNode)this.node);
        this.subModuleNodeView.createPartControl((Composite)new Shell());
        this.node.activate();
    }

    protected void tearDown() throws Exception {
        this.node.deactivate(null);
        this.removeExtension("sub.module.view.test");
        super.tearDown();
    }

    public void testBlocking() {
        this.node.setBlocked(true);
        Composite parentComposite = (Composite)ReflectionUtils.invokeHidden((Object)this.subModuleNodeView, (String)"getParentComposite", (Object[])new Object[0]);
        Composite contentComposite = (Composite)ReflectionUtils.invokeHidden((Object)this.subModuleNodeView, (String)"getContentComposite", (Object[])new Object[0]);
        SubModuleViewTest.assertFalse((boolean)contentComposite.isEnabled());
        Cursor waitCursor = parentComposite.getDisplay().getSystemCursor(1);
        SubModuleViewTest.assertSame((Object)waitCursor, (Object)parentComposite.getCursor());
        this.node.setBlocked(false);
        SubModuleViewTest.assertTrue((boolean)contentComposite.isEnabled());
        Cursor arrowCursor = parentComposite.getDisplay().getSystemCursor(0);
        SubModuleViewTest.assertSame((Object)arrowCursor, (Object)parentComposite.getCursor());
    }

    public void xxx_testCreateController() throws Exception {
        SubModuleViewTest.assertNotNull((Object)this.subModuleNodeView.getController());
        SubModuleViewTest.assertEquals((Object)this.node, (Object)this.subModuleNodeView.getController().getNavigationNode());
    }

    public void testBindOnActivate() throws Exception {
        this.nodesBoundToView.clear();
        this.anotherNode.activate();
        SubModuleViewTest.assertTrue((boolean)this.nodesBoundToView.isEmpty());
        this.anotherNodeSameView.activate();
        SubModuleViewTest.assertTrue((boolean)this.nodesBoundToView.isEmpty());
        this.node.activate();
        SubModuleViewTest.assertEquals((int)1, (int)this.nodesBoundToView.size());
        SubModuleViewTest.assertSame((Object)this.node, (Object)this.nodesBoundToView.get(0));
    }

    private final class TestView
    extends SubModuleView {
        private TestView() {
        }

        public void bind(SubModuleNode node) {
            SubModuleViewTest.this.nodesBoundToView.add(node);
        }

        public SubModuleNode getNavigationNode() {
            return SubModuleViewTest.this.node;
        }

        protected void basicCreatePartControl(Composite parent) {
        }
    }
}

