/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.util.Map;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeControllerTest;
import org.eclipse.riena.ui.ridgets.ClassRidgetMapper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;

@NonUITestCase
public class ClassRidgetMapperTest
extends RienaTestCase {
    private ClassRidgetMapper mapper;

    protected void setUp() throws Exception {
        super.setUp();
        ReflectionUtils.setHidden(SwtControlRidgetMapper.class, (String)"instance", (Object)ReflectionUtils.newInstanceHidden(SwtControlRidgetMapper.class, (Object[])new Object[0]));
        this.mapper = ClassRidgetMapper.getInstance();
    }

    protected void tearDown() throws Exception {
        ReflectionUtils.setHidden(ClassRidgetMapper.class, (String)"instance", (Object)ReflectionUtils.newInstanceHidden(ClassRidgetMapper.class, (Object[])new Object[0]));
        this.mapper = null;
        super.tearDown();
    }

    public void testAddMapping() throws Exception {
        this.mapper.addMapping(IMockRidget.class, NavigationNodeControllerTest.MockRidget.class);
        Class ridget = this.mapper.getRidgetClass(IMockRidget.class);
        ClassRidgetMapperTest.assertNotNull((Object)ridget);
        ClassRidgetMapperTest.assertEquals((String)NavigationNodeControllerTest.MockRidget.class.getName(), (String)ridget.getName());
        Map mappings = (Map)ReflectionUtils.getHidden((Object)this.mapper, (String)"mappings");
        int size = mappings.size();
        this.mapper.addMapping(null, null);
        ClassRidgetMapperTest.assertEquals((int)size, (int)mappings.size());
    }

    public void testGetRidgetClass() throws Exception {
        Class ridget = this.mapper.getRidgetClass(ITextRidget.class);
        ClassRidgetMapperTest.assertNotNull((Object)ridget);
        ClassRidgetMapperTest.assertEquals((String)TextRidget.class.getName(), (String)ridget.getName());
        try {
            this.mapper.getRidgetClass(IMockRidget.class);
            ClassRidgetMapperTest.fail((String)"BindingException expected");
        }
        catch (BindingException bindingException) {
            this.ok("BindingException expected");
        }
    }

    static interface IMockRidget
    extends IRidget {
    }

    static interface IMockRidget2
    extends IMockRidget {
    }

    static interface IMockRidget3
    extends IMockRidget {
    }
}

