/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.core.injector.extension.ExtensionInterface;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.INavigationNodeProvider;

public final class NavigationNodeProvider {
    private static NavigationNodeProvider navigationNodeProvider = new NavigationNodeProvider();
    private INavigationNodeProvider provider;

    static {
        Wire.instance((Object)navigationNodeProvider).andStart(Activator.getDefault().getContext());
    }

    private NavigationNodeProvider() {
    }

    public static INavigationNodeProvider getInstance() {
        return navigationNodeProvider.getProvider();
    }

    private INavigationNodeProvider getProvider() {
        return this.provider;
    }

    @InjectExtension
    public void update(INavigationNodeProviderExtension[] availableExtensions) {
        if (this.provider != null) {
            this.provider.cleanUp();
        }
        INavigationNodeProviderExtension found = null;
        int maxPriority = Integer.MIN_VALUE;
        this.provider = null;
        INavigationNodeProviderExtension[] iNavigationNodeProviderExtensionArray = availableExtensions;
        int n = availableExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            INavigationNodeProviderExtension probe = iNavigationNodeProviderExtensionArray[n2];
            int p = probe.getPriority();
            if (found == null || p > maxPriority) {
                found = probe;
                maxPriority = p;
            }
            ++n2;
        }
        if (found != null) {
            this.provider = found.createClass();
        }
    }

    @ExtensionInterface(id="navigationNodeProvider")
    public static interface INavigationNodeProviderExtension {
        public String getId();

        public int getPriority();

        public INavigationNodeProvider createClass();
    }
}

