/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.osgi.framework.Bundle;

public final class RienaLocations {
    public static final String RIENA_NAME = "riena";
    private static final Logger LOGGER = Log4r.getLogger(RienaLocations.class);

    private RienaLocations() {
    }

    public static File getDataArea() {
        Location instanceAreaLocation = Platform.getInstanceLocation();
        if (instanceAreaLocation == null || instanceAreaLocation.getURL() == null) {
            throw new RuntimeException("No instance area could be found! Only set osgi.instance.area to @noDefault if you specify one explicitly!");
        }
        LOGGER.log(4, "Platform Instance Location: " + instanceAreaLocation.getURL().toString());
        File dataArea = new File(instanceAreaLocation.getURL().getFile(), RIENA_NAME);
        return RienaLocations.existingOrNewDirectory(dataArea);
    }

    private static File existingOrNewDirectory(File location) {
        boolean created;
        if (location.isDirectory()) {
            LOGGER.log(4, "Found directory at " + location.getAbsolutePath());
            return location;
        }
        LOGGER.log(4, String.valueOf(location.getAbsolutePath()) + " is not a directory.");
        boolean canWrite = true;
        File tempFile = location;
        while (tempFile.getParentFile() != null && canWrite) {
            if (!(tempFile = tempFile.getParentFile()).canWrite()) break;
        }
        String fallbackLocation = String.valueOf(System.getProperty("user.home")) + "/." + System.getProperty("eclipse.product");
        if (!canWrite) {
            LOGGER.log(4, "No write permissions; using ${user.home}/.${eclipse.product} as fallback");
            location = new File(fallbackLocation);
        }
        if (!(created = location.mkdirs()) && canWrite) {
            LOGGER.log(4, "Could not create; using ${user.home}/.${eclipse.product} as fallback");
            location = new File(fallbackLocation);
            created = location.mkdirs();
            if (!created) {
                throw new RuntimeException("Could not create fallback instance area at '" + location.getAbsolutePath() + "'. Giving up.");
            }
        }
        Assert.isLegal((boolean)created, (String)"Missing instance area could not be created.");
        LOGGER.log(4, "Created instance area directory at " + location.getAbsolutePath());
        return location;
    }

    public static File getDataArea(Bundle bundle) {
        Assert.isLegal((bundle != null ? 1 : 0) != 0, (String)"bundle must not be null.");
        String symbolicName = bundle.getSymbolicName();
        Assert.isLegal((boolean)StringUtils.isGiven(symbolicName), (String)"no symbolic name for bundle.");
        File dataArea = new File(RienaLocations.getDataArea(), symbolicName);
        return RienaLocations.existingOrNewDirectory(dataArea);
    }
}

