/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common;

import java.util.Dictionary;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.RienaPlugin;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.ContainerModel;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.security.common.SecurityCallHook;
import org.eclipse.riena.internal.security.common.SentinelServiceImpl;
import org.eclipse.riena.internal.security.common.SimpleSubjectHolder;
import org.eclipse.riena.internal.security.common.SimpleThreadedSubjectHolder;
import org.eclipse.riena.internal.security.common.authorization.PermissionCache;
import org.eclipse.riena.internal.security.common.session.SimpleSessionHolder;
import org.eclipse.riena.internal.security.common.session.SimpleThreadedSessionHolder;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authorization.IAuthorizationService;
import org.eclipse.riena.security.common.authorization.IPermissionCache;
import org.eclipse.riena.security.common.authorization.ISentinelService;
import org.eclipse.riena.security.common.session.ISessionHolder;
import org.osgi.framework.BundleContext;

public class Activator
extends RienaPlugin {
    public static final String PLUGIN_ID = "org.eclipse.riena.security.common";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        context.registerService(ISessionHolder.class.getName(), (Object)(ContainerModel.isClient() ? new SimpleSessionHolder() : new SimpleThreadedSessionHolder()), null);
        SecurityCallHook hook = new SecurityCallHook();
        Wire.instance((Object)hook).andStart(context);
        context.registerService(ICallHook.class.getName(), (Object)hook, null);
        context.registerService(ISubjectHolder.class.getName(), (Object)(ContainerModel.isClient() ? new SimpleSubjectHolder() : new SimpleThreadedSubjectHolder()), null);
        context.registerService(IPermissionCache.class.getName(), (Object)new PermissionCache(), null);
        this.createSentinelServiceAndInjectors();
    }

    private void createSentinelServiceAndInjectors() {
        SentinelServiceImpl sentinelService = new SentinelServiceImpl();
        this.getContext().registerService(ISentinelService.class.getName(), (Object)sentinelService, (Dictionary)RienaConstants.newDefaultServiceProperties());
        Inject.service(IPermissionCache.class).useRanking().into((Object)sentinelService).andStart(Activator.getDefault().getContext());
        Inject.service(ISubjectHolder.class).useRanking().into((Object)sentinelService).andStart(Activator.getDefault().getContext());
        Inject.service(IAuthorizationService.class).useRanking().into((Object)sentinelService).andStart(Activator.getDefault().getContext());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

