/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Assert;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.BreakIteratorFactory;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.ThaiBreakIterator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;

final class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim {
    static final ICULocaleService service = new BFService();
    private static final String[] KIND_NAMES = new String[]{"grapheme", "word", "line", "sentence", "title"};
    private static final boolean[] DICTIONARY_POSSIBLE;

    static {
        boolean[] blArray = new boolean[5];
        blArray[1] = true;
        blArray[2] = true;
        DICTIONARY_POSSIBLE = blArray;
    }

    BreakIteratorFactory() {
    }

    public Object registerInstance(BreakIterator iter, ULocale locale, int kind) {
        iter.setText(new StringCharacterIterator(""));
        return service.registerObject((Object)iter, locale, kind);
    }

    public boolean unregister(Object key) {
        if (service.isDefault()) {
            return false;
        }
        return service.unregisterFactory((ICUService.Factory)key);
    }

    public Locale[] getAvailableLocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt42b");
        }
        return service.getAvailableLocales();
    }

    public ULocale[] getAvailableULocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt42b");
        }
        return service.getAvailableULocales();
    }

    public BreakIterator createBreakIterator(ULocale locale, int kind) {
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance(locale, kind);
        }
        ULocale[] actualLoc = new ULocale[1];
        BreakIterator iter = (BreakIterator)service.get(locale, kind, actualLoc);
        iter.setLocale(actualLoc[0], actualLoc[0]);
        return iter;
    }

    private static BreakIterator createBreakInstance(ULocale locale, int kind) {
        RuleBasedBreakIterator iter = null;
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b/brkitr", locale);
        InputStream ruleStream = null;
        try {
            String typeKey = KIND_NAMES[kind];
            String brkfname = rb.getStringWithFallback("boundaries/" + typeKey);
            String rulesFileName = "data/icudt42b/brkitr/" + brkfname;
            ruleStream = ICUData.getStream(rulesFileName);
        }
        catch (Exception e) {
            throw new MissingResourceException(e.toString(), "", "");
        }
        if (DICTIONARY_POSSIBLE[kind]) {
            try {
                if (locale.getLanguage().equals("th")) {
                    String dictType = "Thai";
                    String dictFileName = rb.getStringWithFallback("dictionaries/" + dictType);
                    dictFileName = "data/icudt42b/brkitr/" + dictFileName;
                    InputStream is = ICUData.getStream(dictFileName);
                    iter = new ThaiBreakIterator(ruleStream, is);
                }
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (IOException e) {
                Assert.fail(e);
            }
        }
        if (iter == null) {
            try {
                iter = RuleBasedBreakIterator.getInstanceFromCompiledRules(ruleStream);
            }
            catch (IOException e) {
                Assert.fail(e);
            }
        }
        ULocale uloc = ULocale.forLocale(rb.getLocale());
        iter.setLocale(uloc, uloc);
        return iter;
    }

    static /* synthetic */ BreakIterator access$0(ULocale uLocale, int n) {
        return BreakIteratorFactory.createBreakInstance(uLocale, n);
    }

    private static class BFService
    extends ICULocaleService {
        BFService() {
            super("BreakIterator");
            class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                final /* synthetic */ BFService this$1;

                RBBreakIteratorFactory(BFService bFService) {
                    this.this$1 = bFService;
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService srvc) {
                    return BreakIteratorFactory.access$0(loc, kind);
                }
            }
            this.registerFactory(new RBBreakIteratorFactory(this));
            this.markDefault();
        }
    }
}

