/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.sample.app.server;

import java.security.AccessControlException;
import java.security.Permission;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.riena.sample.app.common.model.Address;
import org.eclipse.riena.sample.app.common.model.Birth;
import org.eclipse.riena.sample.app.common.model.Customer;
import org.eclipse.riena.sample.app.common.model.CustomersPermission;
import org.eclipse.riena.sample.app.common.model.ICustomerSearch;
import org.eclipse.riena.sample.app.common.model.ICustomers;
import org.eclipse.riena.sample.app.common.model.Offer;
import org.eclipse.riena.security.common.authorization.Sentinel;

public class Customers
implements ICustomers,
ICustomerSearch {
    private Map<Integer, Customer> customers = new HashMap<Integer, Customer>();
    private Map<Integer, Set<Offer>> offers = new HashMap<Integer, Set<Offer>>();
    private int nextUniqueCustomerNumber = 1;

    public Customers() {
        this.initializeCustomers();
        this.initializeOffers();
    }

    public Integer getNextUniqueCustomerNumber() {
        return this.nextUniqueCustomerNumber++;
    }

    public void store(Customer customer) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new CustomersPermission("riena.sample", "store"));
        }
        this.storeInternal(customer);
    }

    private void storeInternal(Customer customer) {
        customer.setId((long)customer.getCustomerNumber().intValue());
        this.customers.put(customer.getCustomerNumber(), customer);
    }

    public Customer[] findCustomer(Customer searchedCustomer) {
        ArrayList<Customer> l = new ArrayList<Customer>();
        for (Customer c : this.customers.values()) {
            if (!this.isIdentical(c, searchedCustomer)) continue;
            l.add(c);
        }
        return l.toArray(new Customer[l.size()]);
    }

    public Customer[] findCustomerWithPermission(Customer searchedCustomer) {
        if (!Sentinel.checkAccess((Permission)new CustomersPermission("riena.sample", "find"))) {
            throw new AccessControlException("no rights for current user for this operation");
        }
        return this.findCustomer(searchedCustomer);
    }

    public Offer[] getOffers(Integer customerNumber) {
        Set<Offer> customerOffers = this.offers.get(customerNumber);
        if (customerOffers == null) {
            return new Offer[0];
        }
        return customerOffers.toArray(new Offer[customerOffers.size()]);
    }

    private boolean isIdentical(Customer customer, Customer searchedCustomer) {
        if (searchedCustomer.getCustomerNumber() != null && !searchedCustomer.getCustomerNumber().equals(customer.getCustomerNumber())) {
            return false;
        }
        if (!this.contains(customer.getLastName(), searchedCustomer.getLastName())) {
            return false;
        }
        return this.contains(customer.getFirstName(), searchedCustomer.getFirstName());
    }

    private boolean contains(String original, String other) {
        if (other == null || other.equals("")) {
            return true;
        }
        return original.toUpperCase().contains(other.toUpperCase());
    }

    private void initializeCustomers() {
        Customer customer = new Customer();
        customer.setFirstName("Han");
        customer.setLastName("Solo");
        Address address = new Address();
        address.setCity("Frankfurt am Main");
        address.setStreet("Am Main 233");
        address.setZipCode("61236");
        address.setCountry("Germany");
        customer.setAddress(address);
        customer.setBirth(new Birth());
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        try {
            customer.getBirth().setBirthDay(format.parse("01.04.1962"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        customer.getBirth().setBirthPlace("Frankfurt");
        customer.setBankData(new ArrayList());
        this.initializeCustomerNumber(customer);
        customer = new Customer();
        customer.setFirstName("Luke");
        customer.setLastName("Skywalker");
        address = new Address();
        address.setCity("Washington");
        address.setStreet("Any Road 845");
        address.setZipCode("98123898");
        address.setCountry("USA");
        customer.setAddress(address);
        customer.setBirth(new Birth());
        try {
            customer.getBirth().setBirthDay(format.parse("01.04.1963"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        customer.getBirth().setBirthPlace("Frankfurt");
        customer.setBankData(new ArrayList());
        this.initializeCustomerNumber(customer);
        customer = new Customer();
        customer.setFirstName("Frodo");
        customer.setLastName("Baggins");
        address = new Address();
        address.setCity("Hanau");
        address.setStreet("Gr\u00fcner Weg 3");
        address.setZipCode("62342");
        address.setCountry("Germany");
        customer.setAddress(address);
        customer.setBirth(new Birth());
        try {
            customer.getBirth().setBirthDay(format.parse("01.04.1964"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        customer.getBirth().setBirthPlace("Frankfurt");
        customer.setBankData(new ArrayList());
        this.initializeCustomerNumber(customer);
    }

    private void initializeOffers() {
        Offer offer = new Offer(Integer.valueOf(1), Integer.valueOf(1));
        this.addOffer(offer);
        offer = new Offer(Integer.valueOf(1), Integer.valueOf(2));
        this.addOffer(offer);
    }

    private void addOffer(Offer offer) {
        Set<Offer> customerOffers = this.offers.get(offer.getCustomerNumber());
        if (customerOffers == null) {
            customerOffers = new HashSet<Offer>();
            this.offers.put(offer.getCustomerNumber(), customerOffers);
        }
        customerOffers.add(offer);
    }

    private void initializeCustomerNumber(Customer customer) {
        customer.setCustomerNumber(this.getNextUniqueCustomerNumber());
        this.storeInternal(customer);
    }
}

