/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.riena.core.exception.Failure;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.BundleUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LnfManager {
    public static final String RIENA_LNF_SYSTEM_PROPERTY = "riena.lnf";
    private static RienaDefaultLnf defaultLnf = new RienaDefaultLnf();
    private static RienaDefaultLnf currentLnf;
    private static final String BUNDLE_CLASS_NAME_SEPARATOR = ":";

    private LnfManager() {
    }

    public static void setDefaultLnf(RienaDefaultLnf defaultLnf) {
        Assert.isNotNull((Object)defaultLnf, (String)"defaultLnf must not be null.");
        LnfManager.defaultLnf = defaultLnf;
        LnfManager.setLnf(null);
    }

    public static void setLnf(String currentLnfClassName) {
        LnfManager.setLnf(LnfManager.createLnf(currentLnfClassName));
    }

    public static void setLnf(RienaDefaultLnf currentLnf) {
        if (LnfManager.currentLnf == currentLnf) {
            return;
        }
        if (LnfManager.currentLnf != null) {
            LnfManager.currentLnf.uninitialize();
        }
        if ((LnfManager.currentLnf = currentLnf) != null) {
            if (Activator.getDefault() != null) {
                Wire.instance((Object)LnfManager.currentLnf).andStart(Activator.getDefault().getContext());
            }
            LnfManager.currentLnf.initialize();
        }
    }

    public static RienaDefaultLnf getLnf() {
        if (currentLnf == null) {
            String className = System.getProperty(RIENA_LNF_SYSTEM_PROPERTY);
            if (className != null) {
                LnfManager.setLnf(className);
            } else {
                LnfManager.setLnf(defaultLnf);
            }
        }
        return currentLnf;
    }

    @Deprecated
    public static String getLnfClassName() {
        return LnfManager.getLnf().getClass().getName();
    }

    public static void dispose() {
        if (currentLnf != null) {
            currentLnf.uninitialize();
            currentLnf = null;
        }
    }

    private static RienaDefaultLnf createLnf(String lnfClassName) {
        if (lnfClassName == null) {
            return null;
        }
        Class lnfClass = null;
        if (lnfClassName.contains(BUNDLE_CLASS_NAME_SEPARATOR)) {
            String[] parts = lnfClassName.split(BUNDLE_CLASS_NAME_SEPARATOR);
            String bundleSymbolicName = parts[0];
            String className = parts[1];
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            if (!BundleUtil.isReady(bundle)) {
                throw new LnfManagerFailure("can't load LnfClass '" + className + "' from bundle " + bundleSymbolicName + " because bundle is not ready.");
            }
            try {
                lnfClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new LnfManagerFailure("can't load LnfClass '" + className + "' from bundle " + bundleSymbolicName + ".", e);
            }
        } else {
            lnfClass = LnfManager.loadClass(lnfClassName);
        }
        try {
            return (RienaDefaultLnf)lnfClass.newInstance();
        }
        catch (Exception e) {
            throw new LnfManagerFailure("can't create instance for LnfClass '" + lnfClass.getName() + ".", e);
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return LnfManager.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LnfManagerFailure("Can't load LnfClass '" + className + "'. Please use the class format specified in the LnfManager or change your bundle dependencies.", e);
        }
    }

    private static class LnfManagerFailure
    extends Failure {
        public LnfManagerFailure(String msg) {
            super(msg);
        }

        public LnfManagerFailure(String msg, Throwable thrown) {
            super(msg, thrown);
        }
    }
}

