/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.uiprocess;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.ui.swt.RienaWindowRenderer;
import org.eclipse.riena.ui.swt.nls.Messages;
import org.eclipse.riena.ui.swt.uiprocess.IProcessWindowListener;
import org.eclipse.riena.ui.swt.uiprocess.IUIProcessWindow;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessControl;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class UIProcessWindow
extends ApplicationWindow
implements IUIProcessWindow {
    private static final int CANCEL_BUTTON_WIDTH = 70;
    private static final int PROGRESS_BAR_WIDTH = 210;
    private final UIProcessControl progressControl;
    private final Set<IProcessWindowListener> windowListeners;
    private final RienaWindowRenderer windowRenderer;
    private ProgressBar progressBar;
    private Label description;
    private Label percent;

    public UIProcessWindow(Shell parentShell, UIProcessControl progressControl) {
        super(parentShell);
        this.progressControl = progressControl;
        this.windowListeners = new HashSet<IProcessWindowListener>();
        this.windowRenderer = new RienaWindowRenderer((Window)this);
    }

    public void create() {
        this.setShellStyle(this.windowRenderer.computeShellStyle());
        super.create();
    }

    private void createWindowLayout(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        parent.setLayout((Layout)layout);
    }

    protected Control createContents(Composite parent) {
        Control contentsComposite = this.windowRenderer.createContents(parent);
        Composite centerComposite = this.windowRenderer.getCenterComposite();
        this.createWindowLayout(centerComposite);
        FormData formDate = new FormData();
        formDate.width = 210;
        formDate.height = 35;
        this.description = new Label(centerComposite, 0);
        this.description.setBackground(centerComposite.getDisplay().getSystemColor(1));
        this.description.setLayoutData((Object)formDate);
        formDate = new FormData();
        formDate.width = 30;
        formDate.height = 13;
        formDate.top = new FormAttachment((Control)this.description, 5);
        this.percent = new Label(centerComposite, 0);
        this.percent.setBackground(centerComposite.getDisplay().getSystemColor(1));
        this.percent.setLayoutData((Object)formDate);
        formDate = new FormData();
        formDate.top = new FormAttachment((Control)this.percent, 10);
        formDate.width = 210;
        formDate.height = 15;
        this.progressBar = new ProgressBar(centerComposite, 256);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setLayoutData((Object)formDate);
        centerComposite.setBackground(centerComposite.getDisplay().getSystemColor(1));
        Button cancel = new Button(centerComposite, 0);
        cancel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UIProcessWindow.this.progressControl.fireCanceled(false);
            }

            public void widgetSelected(SelectionEvent e) {
                UIProcessWindow.this.progressControl.fireCanceled(false);
            }
        });
        cancel.setText(Messages.UIProcessWindow_cancel);
        formDate = new FormData();
        formDate.top = new FormAttachment((Control)this.progressBar, 10);
        formDate.width = 70;
        formDate.left = new FormAttachment(0, 70);
        cancel.setLayoutData((Object)formDate);
        return contentsComposite;
    }

    public Label getPercent() {
        return this.percent;
    }

    public Label getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.getDescription().setText(description);
    }

    public void closeWindow() {
        this.close();
    }

    public boolean close() {
        this.fireWindowAboutToClose();
        return super.close();
    }

    public void openWindow() {
        this.open();
    }

    public int getShellStyle() {
        return super.getShellStyle();
    }

    public void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle);
    }

    public void addProcessWindowListener(IProcessWindowListener listener) {
        this.windowListeners.add(listener);
    }

    protected void fireWindowAboutToClose() {
        for (IProcessWindowListener listener : this.windowListeners) {
            listener.windowAboutToClose();
        }
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    protected void createTrimWidgets(Shell shell) {
    }
}

