/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;

public class BrowserRidget
extends AbstractValueRidget
implements IBrowserRidget {
    private final BrowserUrlListener locationListener = new BrowserUrlListener();
    private String url;
    private String text;

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Browser.class);
    }

    protected void bindUIControl() {
        Browser control = this.getUIControl();
        if (control != null) {
            this.updateUIControl();
            control.addLocationListener((LocationListener)this.locationListener);
        }
    }

    protected void unbindUIControl() {
        Browser control = this.getUIControl();
        if (control != null) {
            control.removeLocationListener((LocationListener)this.locationListener);
        }
        super.unbindUIControl();
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"url");
    }

    public Browser getUIControl() {
        return (Browser)super.getUIControl();
    }

    public String getText() {
        return this.text;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void setText(String text) {
        if (!StringUtils.equals((CharSequence)this.text, (CharSequence)text)) {
            this.text = text;
            String oldUrl = this.url;
            this.url = null;
            this.updateUIControl();
            this.firePropertyChange("url", oldUrl, this.url);
        }
    }

    public void setUrl(String url) {
        if (!StringUtils.equals((CharSequence)this.url, (CharSequence)url)) {
            String oldUrl = this.getUrl();
            this.text = null;
            this.url = url;
            this.updateUIControl();
            this.firePropertyChange("url", oldUrl, this.url);
        }
    }

    private String convertNullToEmpty(String string) {
        return string != null ? string : "";
    }

    private void updateUIControl() {
        Browser control = this.getUIControl();
        if (control != null) {
            if (this.text != null) {
                if (!this.text.equals(control.getText())) {
                    this.locationListener.unblock();
                    control.setText(this.text);
                }
            } else {
                String url = this.convertNullToEmpty(this.url);
                if (!url.equals(control.getUrl())) {
                    this.locationListener.unblock();
                    control.setUrl(url);
                }
            }
        }
    }

    private final class BrowserUrlListener
    implements LocationListener {
        private boolean block;

        private BrowserUrlListener() {
        }

        public void unblock() {
            this.block = false;
        }

        public void changing(LocationEvent event) {
            if (BrowserRidget.this.isOutputOnly() && this.block) {
                event.doit = false;
            }
            this.block = true;
        }

        public void changed(LocationEvent event) {
            if (event.top && !this.isNullOrAboutBlank(event.location)) {
                BrowserRidget.this.setUrl(event.location);
            }
        }

        private boolean isNullOrAboutBlank(String url) {
            return url == null || "about:blank".equals(url);
        }
    }
}

