/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.EventListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DisabledMarkerVisualizer {
    private static final EventListener DISABLED_MARKER_PAINTER = SWTFacade.getDefault().createDisabledPainter();
    private final IRidget ridget;

    public DisabledMarkerVisualizer(IRidget ridget) {
        this.ridget = ridget;
    }

    public void updateDisabled() {
        this.updateDisabled(this.getControl(), this.getRidget().isEnabled());
    }

    private void updateDisabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        this.removePaintlistener(control);
        if (!enabled) {
            this.addPaintlistener(control);
        }
        if (control instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)control;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.updateDisabled(child, enabled);
                ++n2;
            }
        }
        control.redraw();
    }

    protected void removePaintlistener(Control control) {
        SWTFacade facade = SWTFacade.getDefault();
        facade.removePaintListener(control, DISABLED_MARKER_PAINTER);
    }

    protected void addPaintlistener(Control control) {
        SWTFacade facade = SWTFacade.getDefault();
        facade.addPaintListener(control, DISABLED_MARKER_PAINTER);
    }

    private Control getControl() {
        return (Control)this.getRidget().getUIControl();
    }

    private IRidget getRidget() {
        return this.ridget;
    }
}

