/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class SharedColors {
    public static final String COLOR_FLASH_ERROR = "COLOR_FLASH_ERROR";
    public static final String COLOR_MANDATORY = "COLOR_MANDATORY";
    public static final String COLOR_MANDATORY_OUTPUT = "COLOR_MANDATORY_OUTPUT";
    public static final String COLOR_NEGATIVE = "COLOR_NEGATIVE";
    public static final String COLOR_OUTPUT = "COLOR_OUTPUT";
    private Map<String, Color> sharedColors;

    SharedColors(Display display) {
        Object[] values = new Object[]{COLOR_MANDATORY, new RGB(255, 255, 175), COLOR_OUTPUT, new RGB(231, 233, 245), COLOR_MANDATORY_OUTPUT, new RGB(255, 249, 216), COLOR_FLASH_ERROR, new RGB(250, 190, 190), COLOR_NEGATIVE, new RGB(255, 0, 0)};
        this.sharedColors = new HashMap<String, Color>();
        int i = 0;
        while (i < values.length) {
            String key = (String)values[i];
            RGB rgb = (RGB)values[i + 1];
            Color color = new Color((Device)display, rgb);
            this.sharedColors.put(key, color);
            i += 2;
        }
    }

    Color getSharedColor(String colorKey) {
        Assert.isNotNull(this.sharedColors, (String)"Shared colors are disposed");
        Color result = this.sharedColors.get(colorKey);
        Assert.isNotNull((Object)result, (String)("Could not find color with key: " + colorKey));
        return result;
    }

    void dispose() {
        if (this.sharedColors != null) {
            for (Color color : this.sharedColors.values()) {
                color.dispose();
            }
            this.sharedColors = null;
        }
    }
}

