/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ListBinding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectableRidget
extends AbstractSWTRidget
implements ISelectableRidget {
    private final WritableValue singleSelectionObservable;
    private final WritableList multiSelectionObservable;
    private Binding singleSelectionBinding;
    private ListBinding multiSelectionBinding;
    private ISelectableRidget.SelectionType selectionType = ISelectableRidget.SelectionType.SINGLE;
    private ListenerList<ISelectionListener> selectionListeners;

    public AbstractSelectableRidget() {
        this.singleSelectionObservable = new SingleSelectionObservable();
        this.multiSelectionObservable = new MultiSelectionObservable();
    }

    public void addSelectionListener(ISelectionListener selectionListener) {
        Assert.isNotNull((Object)selectionListener, (String)"selectionListener is null");
        if (this.selectionListeners == null) {
            this.selectionListeners = new ListenerList(ISelectionListener.class);
            this.addPropertyChangeListener("selection", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractSelectableRidget.this.notifySelectionListeners((List)evt.getOldValue(), (List)evt.getNewValue());
                }
            });
        }
        this.selectionListeners.add((Object)selectionListener);
    }

    public final void bindMultiSelectionToModel(IObservableList observableList) {
        if (this.multiSelectionBinding != null) {
            this.multiSelectionBinding.dispose();
        }
        DataBindingContext dbc = new DataBindingContext();
        this.multiSelectionBinding = (ListBinding)dbc.bindList((IObservableList)this.multiSelectionObservable, observableList, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
    }

    public final void bindMultiSelectionToModel(Object selectionHolder, String selectionPropertyName) {
        IObservableList observableList = AbstractSWTRidget.isBean(selectionHolder.getClass()) ? BeansObservables.observeList((Object)selectionHolder, (String)selectionPropertyName) : PojoObservables.observeList((Object)selectionHolder, (String)selectionPropertyName);
        this.bindMultiSelectionToModel(observableList);
    }

    public final void bindSingleSelectionToModel(IObservableValue selectionValue) {
        if (this.singleSelectionBinding != null) {
            this.singleSelectionBinding.dispose();
        }
        DataBindingContext dbc = new DataBindingContext();
        this.singleSelectionBinding = dbc.bindValue((IObservableValue)this.singleSelectionObservable, selectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
    }

    public final void bindSingleSelectionToModel(Object selectionHolder, String selectionPropertyName) {
        IObservableValue observableValue = AbstractSWTRidget.isBean(selectionHolder.getClass()) ? PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName) : PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindSingleSelectionToModel(observableValue);
    }

    public void clearSelection() {
        this.singleSelectionObservable.setValue(null);
        this.multiSelectionObservable.clear();
    }

    public boolean containsOption(Object option) {
        if (this.getRowObservables() == null) {
            return false;
        }
        return this.getRowObservables().contains(option);
    }

    public final IObservableList getMultiSelectionObservable() {
        return this.multiSelectionObservable;
    }

    public final List<Object> getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (ISelectableRidget.SelectionType.SINGLE.equals((Object)this.selectionType)) {
            if (this.singleSelectionObservable.getValue() != null) {
                result.add(this.singleSelectionObservable.getValue());
            }
        } else if (ISelectableRidget.SelectionType.MULTI.equals((Object)this.selectionType)) {
            result.addAll(Arrays.asList(this.multiSelectionObservable.toArray()));
        }
        return result;
    }

    public final ISelectableRidget.SelectionType getSelectionType() {
        return this.selectionType;
    }

    public final IObservableValue getSingleSelectionObservable() {
        return this.singleSelectionObservable;
    }

    public void removeSelectionListener(ISelectionListener selectionListener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove((Object)selectionListener);
        }
    }

    public void setSelection(List<?> newSelection) {
        ListDiff diff;
        this.assertIsBoundToModel();
        List<Object> knownElements = this.getKnownElements(newSelection);
        if (ISelectableRidget.SelectionType.SINGLE.equals((Object)this.selectionType)) {
            Object value = knownElements.size() > 0 ? knownElements.get(0) : null;
            this.singleSelectionObservable.setValue(value);
        } else if (ISelectableRidget.SelectionType.MULTI.equals((Object)this.selectionType) && (diff = Diffs.computeListDiff((List)this.multiSelectionObservable, knownElements)).getDifferences().length > 0) {
            this.multiSelectionObservable.clear();
            this.multiSelectionObservable.addAll(knownElements);
        }
    }

    public final void setSelection(Object newSelection) {
        this.assertIsBoundToModel();
        List<Object> list = Arrays.asList(newSelection);
        this.setSelection(list);
    }

    public void setSelectionType(ISelectableRidget.SelectionType selectionType) {
        Assert.isNotNull((Object)selectionType, (String)"selectionType cannot be null");
        if (ISelectableRidget.SelectionType.NONE.equals((Object)selectionType)) {
            throw new IllegalArgumentException("SelectionType.NONE is not supported by the UI-control");
        }
        if (!this.selectionType.equals((Object)selectionType)) {
            this.selectionType = selectionType;
        }
    }

    public final void updateMultiSelectionFromModel() {
        if (this.multiSelectionBinding != null) {
            this.multiSelectionBinding.updateModelToTarget();
        }
    }

    public final void updateSingleSelectionFromModel() {
        if (this.singleSelectionBinding != null) {
            this.singleSelectionBinding.updateModelToTarget();
        }
    }

    protected abstract List<?> getRowObservables();

    protected final void assertIsBoundToModel() {
        if (this.getRowObservables() == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    protected final void refreshSelection() {
        List<?> rowObservables = this.getRowObservables();
        if (rowObservables != null) {
            boolean doUpdate = false;
            List<Object> oldSelection = this.getSelection();
            ArrayList<Object> newSelection = new ArrayList<Object>();
            for (Object candidate : oldSelection) {
                if (!rowObservables.contains(candidate)) {
                    doUpdate = true;
                    continue;
                }
                newSelection.add(candidate);
            }
            if (doUpdate) {
                this.setSelection(newSelection);
            }
        }
    }

    private List<Object> getKnownElements(List<?> elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<?> rowObservables = this.getRowObservables();
        for (Object element : elements) {
            if (!rowObservables.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    private void notifySelectionListeners(List<?> oldSelectionList, List<?> newSelectionList) {
        if (this.selectionListeners != null) {
            SelectionEvent event = new SelectionEvent((IRidget)this, oldSelectionList, newSelectionList);
            ISelectionListener[] iSelectionListenerArray = (ISelectionListener[])this.selectionListeners.getListeners();
            int n = iSelectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionListener listener = iSelectionListenerArray[n2];
                listener.ridgetSelected(event);
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MultiSelectionObservable
    extends WritableList {
        MultiSelectionObservable() {
            super(new ArrayList(), Object.class);
        }

        protected void fireListChange(ListDiff diff) {
            super.fireListChange(diff);
            if (AbstractSelectableRidget.this.getSelectionType() == ISelectableRidget.SelectionType.MULTI) {
                List<Object> newSelection = Arrays.asList(this.toArray());
                List<Object> oldSelection = this.computeOldSelection(diff, newSelection);
                String key = "selection";
                AbstractSelectableRidget.this.propertyChangeSupport.firePropertyChange(key, oldSelection, newSelection);
            }
        }

        private List<Object> computeOldSelection(ListDiff diff, List<Object> newSelection) {
            ArrayList<Object> oldSelection = new ArrayList<Object>();
            oldSelection.addAll(newSelection);
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry entry = listDiffEntryArray[n2];
                Object element = entry.getElement();
                if (entry.isAddition()) {
                    oldSelection.remove(element);
                } else {
                    oldSelection.add(element);
                }
                ++n2;
            }
            return oldSelection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SingleSelectionObservable
    extends WritableValue {
        SingleSelectionObservable() {
            super(null, Object.class);
        }

        protected void fireValueChange(ValueDiff diff) {
            super.fireValueChange(diff);
            Object newValue = diff.getNewValue();
            Object oldValue = diff.getOldValue();
            if (oldValue != newValue && AbstractSelectableRidget.this.getSelectionType() == ISelectableRidget.SelectionType.SINGLE) {
                String key = "selection";
                AbstractSelectableRidget.this.propertyChangeSupport.firePropertyChange(key, this.toList(oldValue), this.toList(newValue));
            }
        }

        private List<?> toList(Object value) {
            return value == null ? Collections.EMPTY_LIST : Arrays.asList(value);
        }
    }
}

